package com.teemlink.qm.base.web.support;

import cn.myapps.common.Environment;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.lang.reflect.Field;
import java.util.List;

/**
 * 文件上传支持
 * Created by ZhanBo-ZJB on 2017/11/4.
 */
public class MapFileToActionSupport implements DataTransportationSupport<HttpServletRequest,Object>{

    private static final Logger log = LoggerFactory.getLogger(MapFileToActionSupport.class);

    @Override
    public void handle(HttpServletRequest dataSource, Object target) {
        //1、创建一个DiskFileItemFactory工厂
        DiskFileItemFactory factory = new DiskFileItemFactory();
        //2、创建一个文件上传解析器
        ServletFileUpload upload = new ServletFileUpload(factory);
        //解决上传文件名的中文乱码
        upload.setHeaderEncoding("UTF-8");

        //设置内存的临界值为500K
        factory.setSizeThreshold(1024 * 500);

        try {
            File tmp;

            tmp = new File(Environment.getInstance().getWorkspaceRootPath()+File.separator+"temp");

            if(!tmp.exists()){
                tmp.mkdir();
            }

            factory.setRepository(tmp);

            // 1. 得到 FileItem 的集合 items
            List<FileItem> items = upload.parseRequest(dataSource);

            // 2. 遍历 items
            for (FileItem item : items) {
                if (!item.isFormField())  {
                    String fileName = item.getName();

                    StringBuffer buffer = new StringBuffer();
                    String line ;

                    fileName = tmp.getAbsolutePath() +File.separator+ fileName;//文件最终上传的位置

                    InputStream in = item.getInputStream();
                    InputStreamReader read = new InputStreamReader(in,"utf-8");
                    BufferedReader reader = new BufferedReader(read);

                    OutputStream out = new FileOutputStream(fileName);
                    OutputStreamWriter write = new OutputStreamWriter(out,"utf-8");
                    BufferedWriter writer=new BufferedWriter(write);

                    line = reader.readLine(); // 读取第一行

                    while (line != null) { // 如果 line 为空说明读完了
                        buffer.append(line); // 将读到的内容添加到 buffer 中
                        buffer.append("\n"); // 添加换行符
                        line = reader.readLine(); // 读取下一行
                    }
                    writer.write(buffer.toString());

                    writer.close();
                    reader.close();
                    write.close();
                    read.close();
                    out.close();
                    in.close();

                    File file = new File(fileName);

                    Field field = getField(target.getClass(),item.getFieldName());

                    field.set(target,file);
                }
            }
        }catch (Exception e) {
            //log.debug("{}", e.getMessage());
        }

    }

    /**
     * 通过属性名称获取class对象的属性对象(通过回调的方式到父类中寻找属性)
     * @param
     * @return
     */
    private Field getField(Class clazz, String name ){

        Field field = null;

        try{
            field = clazz.getDeclaredField(name);

        }catch (Exception e){
            field = getField(clazz.getSuperclass(),name);

        }

        field.setAccessible(true);
        return field;

    }
}
