package com.teemlink.qm.base.web.support;

import com.teemlink.qm.base.web.MapInModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

import java.lang.reflect.Field;

/**
 * 映射Action属性至ModelAndView支持类
 * Created by ZhanBo-ZJB on 2017/10/22.
 */
public class MapFieldToModelAndViewSupport implements DataTransportationSupport<Object,ModelAndView> {

    private static final Logger log = LoggerFactory.getLogger(MapFieldToModelAndViewSupport.class);

    public Field[] getAllFields(Class clazz) {

        Field[] fields = clazz.getDeclaredFields();

        if(clazz.getSuperclass() != null) {
            Field[] superClassFields = getAllFields(clazz.getSuperclass());

            fields = getMergeArray(fields,superClassFields);
        }

        return  fields;
    }

    public void handle(Object dataSource,ModelAndView target) {
        try{

            //迭代所有属性
            for(Field field : getAllFields(dataSource.getClass())) {

                //设置属性可以访问
                field.setAccessible(true);

                if(field.getAnnotation(MapInModel.class) == null) {
                    continue;
                }

                //获取属性值
                Object value = field.get(dataSource);
                if( value == null || target.getModel().get(field.getName()) != null) {
                    continue;
                }

                //获取属性名称
                String fieldName = field.getName();
                target.addObject(fieldName,value);
            }

        }catch (Exception e) {
            //log.debug("{}", "映射属性到model中发生错误!");
        }
    }

    /**
     * 合并数组
     */
    public Field[] getMergeArray(Field[] al, Field[] bl) {
        Field[] a = al;
        Field[] b = bl;
        Field[] c = new Field[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

}
