package com.teemlink.qm.base.web.support;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * get方法调用支持类
 * Created by ZhanBo-ZJB on 2017/10/28.
 */
public class GetMethodInvokeSupport implements DataTransportationSupport<Object,ModelAndView> {

    protected static final Logger LOG = LoggerFactory.getLogger(GetMethodInvokeSupport.class);

    /**
     * 首字母大写
     * @param name
     * @return
     */
    private String captureName(String name) {
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        return  name;
    }

    /**
     * 通过get方法名称获取属性名称
     */
    private String getFieldName(String methodName) {
        String name = methodName.substring(3);
        name = name.substring(0, 1).toLowerCase() + name.substring(1);
        return name;
    }

    /**
     * 获取所有方法
     * @param clazz
     * @return
     */
    public Method[] getAllMethods(Class clazz) {

        Method[] methods = clazz.getDeclaredMethods();

        if(clazz.getSuperclass() != null) {
            Method[] superClassMethods = getAllMethods(clazz.getSuperclass());

            methods = getMergeArray(methods,superClassMethods);
        }

        return  methods;
    }

    /**
     * 通过参数名称获取get方法名称
     * @param name
     */
    private String getMethodName(String name) {
        return "get"+captureName(name);
    }

    @Override
    public void handle(Object dataSource, ModelAndView target) {

        for(Method method : getAllMethods(dataSource.getClass())) {
            if(method.getName().startsWith("get")){
                if(method.getParameterTypes().length == 0) {
                    try{
                        //方法有RequestMapping注解则不调用
                        if(method.getAnnotation(RequestMapping.class) != null) {
                            continue;
                        }

                        Object result = method.invoke(dataSource);

                        if(result != null && target.getModel().get(getFieldName(method.getName())) == null) {
                            target.addObject(getFieldName(method.getName()),result);
                        }

                    }catch (InvocationTargetException e) {
                        //LOG.debug("{}", method.getName()+"抛出异常! "+e.getMessage());
                    }catch (Exception e) {
                        //LOG.debug("{}", method.getName()+"方法调用失败!");
                    }
                }
            }
        }
    }

    /**
     * 合并数组
     */
    public Method[] getMergeArray(Method[] al, Method[] bl) {
        Method[] a = al;
        Method[] b = bl;
        Method[] c = new Method[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    /**
     * 通过属性名称获取class对象的属性对象(通过回调的方式到父类中寻找属性)
     * @param
     * @return
     */
    private Field getField(Class clazz, String name ){

        Field field = null;

        try{
            field = clazz.getDeclaredField(name);

        }catch (Exception e){
            field = getField(clazz.getSuperclass(),name);

        }

        field.setAccessible(true);
        return field;

    }

}
