package com.teemlink.qm.base.web;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 标记不需要进行参数验证的方法
 * 参数验证有三种形式
 * 1.验证对象所有标记属性
 * 2.验证对象部分标记属性(OnlyValidateParams)
 * 3.忽略该对象的验证(NoValidate)
 * Created by ZhanBo-ZJB on 2017/11/4.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface NoValidate {
    public String[] objectNames();
}
