package com.teemlink.qm.base.schema.dao;

import java.sql.Connection;

import cn.myapps.common.model.table.Table;
import cn.myapps.common.util.DbUtil;

public class PostgreSQLSchemaDAO extends AbstractSchemaDAO {
	
	public PostgreSQLSchemaDAO(Connection conn) throws Exception {
		super(conn);
		this.dbType = "PostgreSQL: ";
		this.schema = DbUtil.getSchema(conn, DbUtil.DBTYPE_POSTGRESQL);
//		this.definition = new PostgreSQLTableDefinition(conn);
	}

	@Override
	protected Table getDBTable(String tableName) {
		return (Table) DbUtil.getTable(tableName, DbUtil.DBTYPE_POSTGRESQL, this.connection);
	}
}
