package com.teemlink.qm.base.schema.dao;

import java.sql.Connection;

import cn.myapps.common.model.table.Table;
import cn.myapps.common.util.DbUtil;

public class MysqlSchemaDAO extends AbstractSchemaDAO {
	
	public MysqlSchemaDAO(Connection conn) throws Exception {
		super(conn);
		this.dbType = "MYSQL: ";
		this.schema = DbUtil.getSchema(conn, DbUtil.DBTYPE_MYSQL);
//		this.definition = new MysqlTableDefinition(conn);
	}

	@Override
	protected Table getDBTable(String tableName) {
		return (Table) DbUtil.getTable(tableName, DbUtil.DBTYPE_MYSQL, this.connection);
	}
}
