package com.teemlink.qm.base.schema.dao;

import java.sql.Connection;

import cn.myapps.common.model.table.Table;
import cn.myapps.common.util.DbUtil;

public class MssqlSchemaDAO extends AbstractSchemaDAO {

	public MssqlSchemaDAO(Connection conn) throws Exception {
		super(conn);
		this.dbType = "MS SQL Server: ";
		this.schema = DbUtil.getSchema(conn, DbUtil.DBTYPE_MSSQL);
//		this.definition = new MssqlTableDefinition(conn);
	}

	@Override
	protected Table getDBTable(String tableName) {
		return (Table) DbUtil.getTable(tableName, DbUtil.DBTYPE_MSSQL, this.connection);
	}

}
