package com.teemlink.qm.base.schema;

import java.sql.Connection;

import com.teemlink.qm.base.schema.dao.*;
import com.teemlink.qm.util.ConnectionManager;

public class SchemaHelper {
    
    private static SchemaHelper instance;
    
    private boolean initialized;
    
	private Connection conn;
	
	private AbstractSchemaDAO schemaDAO;
	
    private SchemaHelper() {
        initialized = false;
    }
	
    public static SchemaHelper getInstance() {
        if (instance == null) {
            synchronized (SchemaHelper.class) {
                if (instance == null) {
                    instance = new SchemaHelper();
                }
            }
        }
        return instance;
    }

	public void init() throws Exception{
		try{
		    if(initialized) return;
			//创建一个链接用于初始化调查问卷数据表
			conn = ConnectionManager.getConnection();
			initSchema();
			initIndex();
			initialized = true;
		}catch(Exception e){
//			e.printStackTrace();
//			throw e;
		}finally{
			if(conn != null && !conn.isClosed()){
				conn.close();
			}
		}
	}

	private void initIndex() throws Exception {
		try {
			getSchemaDAO().initIndex();
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}
	}

	
	public void initSchema() throws Exception{
		try{
//			getSchemaDAO().initTables();
		}catch(Exception e){
			e.printStackTrace();
			throw e;
		}
	}
	
	public AbstractSchemaDAO getSchemaDAO(){
		if(schemaDAO == null){
			try{
				String dbType = ConnectionManager.dbType.toUpperCase();
				if("MSSQL".equals(dbType)){  
					schemaDAO = new MssqlSchemaDAO(getConn());
				}else if("ORACLE".equals(dbType)){
					schemaDAO = new OraclelSchemaDAO(getConn());
				}else if("DB2".equals(dbType)){
					schemaDAO = new DB2SchemaDAO(getConn());
				}else if("MYSQL".equals(dbType)){
					schemaDAO = new MysqlSchemaDAO(getConn());
				}else if("DM".equals(dbType)){
					schemaDAO = new DmSQLSchemaDAO(getConn());
				}
			}catch(Exception e){
				e.printStackTrace();
			}
		}
		return schemaDAO;
	}
	
	public Connection getConn() {
		if(conn ==null){
			try {
				conn = ConnectionManager.getConnection();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		
		return conn;
	}
	
}
