package com.teemlink.qm.base.model;

import cn.myapps.common.util.Security;
import cn.myapps.common.util.SpringApplicationContextUtil;
import com.teemlink.qm.config.FeignConfig;
import com.teemlink.qm.config.UserAPI;

import javax.servlet.http.HttpServletRequest;

public class WebUser extends User {

    public static WebUser getUser(HttpServletRequest request) throws Exception {

        String userId = Security.getUserIdFromToken(request);
        FeignConfig.ACCESS_TOKEN = Security.getToken(userId);
        UserAPI userAPI = SpringApplicationContextUtil.getBean(UserAPI.class);
        ResultWarp<User> resultWarp = userAPI.getUserById(userId);
        WebUser user =new WebUser(resultWarp.getData());
        return user;
    }

    public WebUser() {

    }

    public WebUser(User user) {
        this.setId(user.getId());
        this.setDefaultDepartment(user.getDefaultDepartment());
        this.setDepartments(user.getDepartments());
        this.setDepartmentUser(user.isDepartmentUser());
        this.setDomainid(user.getDomainid());
        this.setEmail(user.getEmail());
        this.setUsername(user.getName());
        this.setLoginno(user.getLoginno());
        this.setName(user.getName());
        this.setRoles(user.getRoles());
        this.setTelephone(user.getTelephone());
    }
}
