package com.teemlink.qm.base.model;

import com.fasterxml.jackson.annotation.JsonInclude;

import java.util.List;

public class Department implements IEntity{

    /**
     *
     */
    private static final long serialVersionUID = 6454730510477423625L;

    /**
     * 主键
     */
    private String id;

    /**
     * 名称
     */
    private String name;

    /**
     * 父级部门id
     */
    private String parentId;

    /**
     * 子部门
     */
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<Department> children;

    /**
     * 是否叶子节点（无子部门）
     */
    private boolean leaf;

    private String code;

    private int valid = 1;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public int getLevel() {
        return level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    private int level;

    private Department superior;

    /* (non-Javadoc)
     * @see com.teemlink.km.common.model.IEntity#setId(java.lang.String)
     */
    @Override
    public void setId(String id) {
        this.id = id;
    }

    /* (non-Javadoc)
     * @see com.teemlink.km.common.model.IEntity#getId()
     */
    @Override
    public String getId() {
        return this.id;
    }

    /**
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * @param name the name to set
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return the children
     */
    public List<Department> getChildren() {
        return children;
    }

    /**
     * @param children the children to set
     */
    public void setChildren(List<Department> children) {
        this.children = children;
    }

    /**
     * @return the parentId
     */
    public String getParentId() {
        return parentId;
    }

    /**
     * @param parentId the parentId to set
     */
    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    /**
     * @return the leaf
     */
    public boolean isLeaf() {
        return leaf;
    }

    /**
     * @param leaf the leaf to set
     */
    public void setLeaf(boolean leaf) {
        this.leaf = leaf;
    }

    public int getValid() {
        return valid;
    }

    public void setValid(int valid) {
        this.valid = valid;
    }

    public Department getSuperior() {
        return superior;
    }

    public void setSuperior(Department superior) {
        this.superior = superior;
    }
}
