package com.teemlink.qm.base.dao;

import java.sql.Connection;

import com.teemlink.qm.answer.dao.*;
import com.teemlink.qm.questionnaire.dao.*;
import com.teemlink.qm.util.ConnectionManager;


public class DaoManager {
	

	public static BaseDAO getQuestionnaireDAO(Connection conn) throws Exception{
		String dbType = ConnectionManager.dbType;
		
		if("MSSQL".equals(dbType)){  
			return new MsSqlQuestionnaireDAO(conn);
		}else if("ORACLE".equals(dbType)){
			return new OracleQuestionnaireDAO(conn);
		}else if("DB2".equals(dbType)){
			return new DB2QuestionnaireDAO(conn);
		}else if("MYSQL".equals(dbType)){
			return new MySqlQuestionnaireDAO(conn);
		}else if("POSTGRESQL".equals(dbType)){
			return new PostgreSQLAnswerDAO(conn);
		}else if("DM".equals(dbType)){
			return new DmSQLAnswerDAO(conn);
		}
		
		return null;
	}
	
	public static BaseDAO getAnswer(Connection conn) throws Exception{
		String dbType = ConnectionManager.dbType;
		
		if("MSSQL".equals(dbType)){  
			return new MsSqlAnswerDAO(conn);
		}else if("ORACLE".equals(dbType)){
			return new OracleAnswerDAO(conn);
		}else if("DB2".equals(dbType)){
			return new DB2AnswerDAO(conn);
		}else if("MYSQL".equals(dbType)){
			return new MySqlAnswerDAO(conn);
		}else if("POSTGRESQL".equals(dbType)){
			return new PostgreSQLQuestionnaireDAO(conn);
		}else if("DM".equals(dbType)){
			return new DmSQLQuestionnaireDAO(conn);
		}
		
		return null;
	}
	
	
	
	
}
