package com.teemlink.qm.base.dao;

import com.teemlink.qm.util.DbTypeUtil;

import java.sql.Connection;
import java.sql.SQLException;

public abstract class AbstractBaseDAO {
	
	protected String dbTag = "MYSQL: ";

	protected String schema = "";
	
	protected String tableName = "";
	
	protected Connection connection;
	
	public AbstractBaseDAO(Connection conn){
		this.connection = conn;
	}
	
	public String getFullTableName(String tblname) {
		if (this.schema != null && !this.schema.trim().equals("")) {
			try {
				String dbType = DbTypeUtil.getDBType(connection);
				String schema = DbTypeUtil.getSchema(connection, dbType);
				return schema+ "." + tblname.trim().toUpperCase();
			} catch (SQLException e) {
				e.printStackTrace();
			}

		}
		return tblname.trim().toUpperCase();
	}

}
