package com.teemlink.qm.base.controller;


import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.util.Security;
import cn.myapps.common.util.SpringApplicationContextUtil;
import com.teemlink.qm.base.model.*;
import com.teemlink.qm.base.service.BaseProcess;
import com.teemlink.qm.config.DepartmentAPI;
import com.teemlink.qm.config.FeignConfig;
import com.teemlink.qm.config.UserAPI;
import com.teemlink.qm.util.Web;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.util.HashMap;
import java.util.Map;

@RestController(value="QMBaseController")
public abstract class BaseController<E> {
	protected static final String ACTION_RESULT_KEY = "status";
	protected static final int ACTION_RESULT_VALUE_SUCCESS = 1;
	protected static final int ACTION_RESULT_VALUE_FAULT = 0;
	
	protected static final String ACTION_MESSAGE_KEY = "message";
	protected static final String ACTION_DATA_KEY = "data";
	
	protected Map<String, Object> dataMap = new HashMap<String, Object>();
	//todo end
	
	protected String[] _selects = null;
	
	protected ParamsTable params;
	
	protected ValueObject content = null;
	
	protected BaseProcess<E> process = null;
	
	protected DataPackage<E> datas = null;
	
	@Autowired  
	protected HttpServletRequest request;
	
	@Autowired
	protected HttpSession session;
	
	public String[] get_selects() {
		return _selects;
	}
	public void set_selects(String[] selects) {
		_selects = selects;
	}
	public ParamsTable getParams() {
		if (params == null) {
			params = ParamsTable.convertHTTP(this.request);

			params.setSessionid(this.request.getSession().getId());

			if (params.getParameter("_pagelines") == null){
				params.setParameter("_pagelines", Web.DEFAULT_LINES_PER_PAGE);
			}
		}

		return params;
	}
	
	public ParamsTable getParams(HttpServletRequest request) {
		if (params == null) {
			params = ParamsTable.convertHTTP(request);

			params.setSessionid(request.getSession().getId());

			if (params.getParameter("_pagelines") == null) {
				params.setParameter("_pagelines", Web.DEFAULT_LINES_PER_PAGE);
			}
		}

		return params;
	}
	
	public ValueObject getContent() {
		return content;
	}
	public void setContent(ValueObject content) {
		this.content = content;
	}
	public DataPackage<E> getDatas() {
		return datas;
	}
	public void setDatas(DataPackage<E> datas) {
		this.datas = datas;
	}
	
	public WebUser getUser() throws Exception{
//		String userId = Security.getUserIdFromToken(request);
//		FeignConfig.ACCESS_TOKEN = Security.getToken(userId);
//		UserAPI userAPI = SpringApplicationContextUtil.getBean(UserAPI.class);
//		ResultWarp<User> resultWarp = userAPI.getUserById(userId);
//		WebUser user = (WebUser) resultWarp.getData();
		WebUser user = WebUser.getUser(request);
		return user;
	}
	
	
	public BaseProcess<E> getProcess() {
		return process;
	}
	
	//todo begin
	/**
     * Struts2序列化指定属性时，必须有该属性的getter方法
     * @return
     */
    public Map<String, Object> getDataMap() {
        return dataMap;
    }
	
	/**
     * 添加Action处理结果
     * @param isSuccess
     * 		是否成功处理
     * @param message
     * 		返回消息
     * @param data
     * 		返回数据
     */
    public  Map<String, Object> addActionResult(boolean isSuccess,String message,Object data){
    	dataMap.put(ACTION_RESULT_KEY, isSuccess?ACTION_RESULT_VALUE_SUCCESS : ACTION_RESULT_VALUE_FAULT );
    	dataMap.put(ACTION_MESSAGE_KEY, message);
    	if(data != null){
    		dataMap.put(ACTION_DATA_KEY, data);
    	}
    	return dataMap;
    }

	public Department getDepartment(String deptid){
		DepartmentAPI departmentAPI = SpringApplicationContextUtil.getBean(DepartmentAPI.class);
		ResultWarp<Department> resultWarp = departmentAPI.getDepartmentById(deptid);
		Department department = resultWarp.getData();
		return department;
	}
	//todo end
//    private User getAnonymousUser(){
//		WebUser vo = new WebUser();
//		vo.setId("1234-5678-90");
//		vo.setName("测试用户");
//		vo.setLoginno("test");
//		vo.setLoginpwd("");
//
//		return vo;
//	}
}
