package com.teemlink.qm.answer.dao;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;


public class OracleAnswerDAO extends AbstractAnswerDAO implements AnswerDAO {

    private static final Logger log = LoggerFactory.getLogger(OracleAnswerDAO.class);

    public OracleAnswerDAO(Connection conn) throws Exception {
        super(conn);
        if (conn != null) {
            try {
                this.schema = conn.getMetaData().getUserName().trim().toUpperCase();
            } catch (SQLException sqle) {
                sqle.printStackTrace();
            }
        }
    }

    @Override
    protected String buildLimitString(String sql, int page, int lines, String orderbyField, String orderbyMode)
            throws SQLException {
        if (lines == Integer.MAX_VALUE) {
            return sql;
        }

        int from = (page - 1) * lines;
        int to = page * lines;
        StringBuffer pagingSelect = new StringBuffer(100);

        pagingSelect.append("select *  FROM  ( select row_.*, rownum rownum_  FROM  ( ");
        pagingSelect.append(sql);
        pagingSelect.append(" ) row_ where rownum <= ");
        pagingSelect.append(to);
        pagingSelect.append(") where rownum_ > ");
        pagingSelect.append(from);

        return pagingSelect.toString();
    }

    /**
     * 添加总页数
     */
    @Override
    public long countBySQL(String sql) throws Exception {
        if (sql == null || sql.trim().equals(""))
            return 0;
        PreparedStatement statement = null;
        ResultSet rs = null;
        sql = "SELECT COUNT(*)  FROM (" + sql + ")";

        log.debug("{}", sql);

        try {
            statement = connection.prepareStatement(sql);
            rs = statement.executeQuery();

            if (rs.next()) {
                return rs.getLong(1);
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            } catch (SQLException se) {
                throw new SQLException("SQL Exception while closing " + "Statement : \n" + se);
            }
        }

        return 0;
    }
}
