package com.teemlink.qm.answer.controller;

import java.util.Map;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.teemlink.qm.base.model.WebUser;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import com.teemlink.qm.answer.model.AnswerVO;
import com.teemlink.qm.answer.service.AnswerProcess;
import com.teemlink.qm.answer.service.AnswerProcessBean;
import com.teemlink.qm.base.controller.BaseController;

import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.util.StringUtil;

@Controller(value="AnswerServiceAction")
@RequestMapping(value="/qm/answerservice")
@Scope(value=ConfigurableBeanFactory.SCOPE_PROTOTYPE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class AnswerServiceController extends BaseController<AnswerVO>{

	public AnswerServiceController() {
		super();
		content = new AnswerVO();
		process = new AnswerProcessBean();
	}


	/**
	 * 获取问卷答案
	 * 
	 * @return
	 */
	@RequestMapping(value="/view.action")
	public Map<String, Object> doView() {
		try {
				ParamsTable params = getParams();
				String id = params.getParameterAsString("id");
				AnswerVO answer = (((AnswerProcess) process).findByQuestionnaireIdAndUserId(id,getUser()));
				return addActionResult(true, "", answer);
		} catch (Exception e) {
			e.printStackTrace();
			return addActionResult(false, e.getMessage(), null);
		}
	}


	/**
	 * 提交答卷
	 */
	@RequestMapping(value="/save.action")
	public Map<String, Object> doSave() {
		try {
			AnswerVO answerVO = (AnswerVO) getContent();
			if(StringUtil.isBlank(answerVO.getQuestionnaire_id())){
				return addActionResult(false, "", null);
			}
			AnswerVO answer = (((AnswerProcess) process).findByQuestionnaireIdAndUserId(answerVO.getQuestionnaire_id(),getUser()));
			if(answer!=null){
				return addActionResult(false, "请勿重复提交", null);
			}
			if(StringUtil.isBlank(answerVO.getId())){
				WebUser user = getUser();
				answerVO.setUserId(user.getId());
				answerVO.setUserName(user.getName());
				((AnswerProcess) process).doSave(answerVO);
			}
			return addActionResult(true, "", null);
		} catch (Exception e) {
			e.printStackTrace();
			return addActionResult(false, e.getMessage(), null);
		}
	}
	
	/**
	 * 获取填空题报表数据
	 * @return
	 */
	@RequestMapping(value="/inputreportform.action")
	public Map<String, Object> doInputReportForm() {
		try {
			ParamsTable params = getParams();
			String id = params.getParameterAsString("id");
			String q_Id = params.getParameterAsString("q_id");
			String currpageStr = params.getParameterAsString("currpage");
			String pagelinesStr = params.getParameterAsString("pagelines");
			int currpage = StringUtil.isBlank(currpageStr)? 1 : Integer.parseInt(currpageStr);
			int pagelines = StringUtil.isBlank(pagelinesStr)? Integer.MAX_VALUE : Integer.parseInt(pagelinesStr);
			
			DataPackage<AnswerVO> vo = ((AnswerProcess) process).findInputReport(id,q_Id,currpage,pagelines);
			return addActionResult(true, "", vo);
		} catch (Exception e) {
			e.printStackTrace();
			return addActionResult(false, e.getMessage(), null);
		}
	}
}
