package com.teemlink.qm.answer.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import cn.myapps.common.util.SpringApplicationContextUtil;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.teemlink.qm.base.model.Department;
import com.teemlink.qm.base.model.ResultWarp;
import com.teemlink.qm.base.model.User;
import com.teemlink.qm.config.DepartmentAPI;
import com.teemlink.qm.config.UserAPI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import com.teemlink.qm.answer.model.AnswerVO;
import com.teemlink.qm.answer.service.AnswerProcess;
import com.teemlink.qm.answer.service.AnswerProcessBean;
import com.teemlink.qm.base.controller.BaseController;
import com.teemlink.qm.base.service.BaseProcess;
import com.teemlink.qm.questionnaire.model.QuestionnaireVO;
import com.teemlink.qm.questionnaire.service.QuestionnaireProcess;
import com.teemlink.qm.questionnaire.service.QuestionnaireProcessBean;

import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.util.StringUtil;

@Controller(value="AnswerAction")
@RequestMapping(value="/qm/answer")
@Scope(value=ConfigurableBeanFactory.SCOPE_PROTOTYPE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class AnswerController extends BaseController<AnswerVO> {
	
	private String question_id;

	private String s_title;

	private String s_jumpType;
	
	@Autowired
	protected HttpServletRequest request;
	
	@Autowired
	protected HttpServletResponse response;
	
	public AnswerController() {
		super();
		content = new AnswerVO();
		process = new AnswerProcessBean();
	}

	/**
	 * 获取问卷
	 * 
	 * @return
	 */
	@RequestMapping(value="/view.action")
	public ModelAndView doView() {
		try {
			ParamsTable params = getParams();
			String id = params.getParameterAsString("id");
			setContent(((AnswerProcess) process).findByQuestionnaireIdAndUserId(id,getUser()));
			/*if (HttpRequestDeviceUtils.isMobileDevice(request) == true) {
				ModelAndView mav = new ModelAndView("/qm/answer/result");
				mav.addObject(content);
				return mav;
			} else {*/
				ModelAndView mav = new ModelAndView("/qm/answer/result");
				mav.addObject(content);
				return mav;
			/*}*/
		}catch (Exception e) {
			e.printStackTrace();
			ModelAndView mav = new ModelAndView("");
			return mav;
		}
	}

	/*@RequestMapping(value="/list.action")
	public ModelAndView doList() {
		try {
			ParamsTable params = getParams();

			String s_title = params.getParameterAsString("s_title");
			if (s_title == null)
				s_title = "";

			String _currpage = params.getParameterAsString("_currpage");
			String _pagelines = params.getParameterAsString("_pagelines");

			int page = (_currpage != null && _currpage.length() > 0) ? Integer
					.parseInt(_currpage) : 1;
			int lines = (_pagelines != null && _pagelines.length() > 0) ? Integer
					.parseInt(_pagelines) : Integer.MAX_VALUE;

			setDatas(((AnswerProcess) process).doQueryByFilter(s_title, page,
					lines, getUser()));
			setS_title(s_title);

			
			if (HttpRequestDeviceUtils.isMobileDevice(request) == true) {
				ModelAndView mav = new ModelAndView("/wap/answer/list");
				mav.addObject(datas);
				mav.addObject(s_title);
				return mav;
			} else {
				ModelAndView mav = new ModelAndView("/qm/answer/list");
				mav.addObject(datas);
				mav.addObject(s_title);
				return mav;
			}
		}catch (Exception e) {
			e.printStackTrace();
			ModelAndView mav = new ModelAndView("");
			return mav;
		}
	}*/

	/*@RequestMapping(value="/showResultList.action")
	public ModelAndView showResultList() {
		try {
			ParamsTable params = getParams();
			// 问卷id
			String questionnaire_id = params.getParameterAsString("id");
			// 问题id
			String question_id = params.getParameterAsString("q_id");
			setDatas(((AnswerProcess) process)
					.doViewForQuestionnaire(questionnaire_id));
			setQuestion_id(question_id);

			if (HttpRequestDeviceUtils.isMobileDevice(request) == true) {
				ModelAndView mav = new ModelAndView("/wap/answer/resultlist");
				mav.addObject(datas);
				mav.addObject(question_id);
				return mav;
			} else {
				ModelAndView mav = new ModelAndView("/qm/answer/resultlist");
				mav.addObject(datas);
				mav.addObject(question_id);
				return mav;
			}
		}catch (Exception e) {
			e.printStackTrace();
			ModelAndView mav = new ModelAndView("");
			return mav;
		}
	}*/

	/**
	 * 问卷编辑
	 */
	/*@RequestMapping(value="/edit.action")
	public ModelAndView doEdit() {
		try {
			ParamsTable params = getParams();
			String id = params.getParameterAsString("id");
			setContent(process.doView(id));

			if (HttpRequestDeviceUtils.isMobileDevice(request) == true) {
				ModelAndView mav = new ModelAndView("/wap/answer/content");
				mav.addObject(content);
				return mav;
			} else {
				ModelAndView mav = new ModelAndView("/qm/answer/content");
				mav.addObject(content);
				return mav;
			}
		}catch (Exception e) {
			e.printStackTrace();
			ModelAndView mav = new ModelAndView("");
			return mav;
		}
	}*/


	/**
	 * 保存问卷
	 */
	@RequestMapping(value="/save.action")
	public ModelAndView doSave() {
		try {
			AnswerVO answer = (AnswerVO) getContent();
			answer.setDomainid(getUser().getDomainid());
			BaseProcess<QuestionnaireVO> q_process = new QuestionnaireProcessBean();
			if (StringUtil.isBlank(answer.getId())) {
				User user = getUser();
				answer.setUserId(user.getId());
				answer.setUserName(user.getUsername());
				String defaultDepartmentId = user.getDefaultDepartment();
				if(!StringUtil.isBlank(defaultDepartmentId)){
					DepartmentAPI departmentAPI = SpringApplicationContextUtil.getBean(DepartmentAPI.class);
					ResultWarp<Department> resultWarp = departmentAPI.getDepartmentById(defaultDepartmentId);
					Department defaultDepartment = resultWarp.getData();
					answer.setUserDepartment(defaultDepartment.getName());
				}
				((AnswerProcess) process).doSave(answer);

				((QuestionnaireProcess) q_process).addPaticipate(answer.getQuestionnaire_id());
				
			}

			answer = (AnswerVO) process.doView(answer.getId());

			setContent(answer);

			/*if (HttpRequestDeviceUtils.isMobileDevice(request) == true) {
				ModelAndView mav = new ModelAndView("/qm/answer/success");
				mav.addObject(content);
				return mav;
			} else {*/
				ModelAndView mav = new ModelAndView("/qm/answer/result");
				mav.addObject("content",content);
				return mav;
			/*}*/
		} catch (Exception e) {
			e.printStackTrace();
			ModelAndView mav = new ModelAndView("");
			return mav;
		}
	}

	//todo begin
	/*@RequestMapping(value="/download.action")
	public void exportPDF() throws IOException, DocumentException{
		try{
			ParamsTable params = getParams();
			String content = params.getParameterAsString("content");
			String c="<?xml version='1.0' encoding='UTF-8'?><html><head><meta http-equiv='content-type' content='text/html; charset=UTF-8' />"
					 +"<style type='text/css' >body {font-family: SimSun;}</style></head><body>"
					+content+"</body></html>";
			String pdfName = "result";
			response.setHeader("Content-disposition", "attachment;filename="+pdfName);     
            response.setContentType("application/pdf");     
            OutputStream os = response.getOutputStream();
			ITextRenderer renderer = new ITextRenderer(); 
			
			renderer.setDocumentFromString(c);
			                 
			ITextFontResolver fontResolver = renderer.getFontResolver();
			fontResolver.addFont("C:/Windows/fonts/simsun.ttc", BaseFont.IDENTITY_H, BaseFont.NOT_EMBEDDED);  
		    renderer.layout();     
			renderer.createPDF(os);     
			os.close();     
		}catch(Exception e){
			addActionResult(false, e.getMessage(), null);
			if(!(e instanceof OBPMValidateException)){
				e.printStackTrace();
			}
		}
	}*/
	//todo end
	
	public String getQuestion_id() {
		return question_id;
	}

	public void setQuestion_id(String question_id) {
		this.question_id = question_id;
	}

	public String getS_title() {
		return s_title;
	}

	public void setS_title(String s_title) {
		this.s_title = s_title;
	}

	public String getS_jumpType() {
		return s_jumpType;
	}

	public void setS_jumpType(String s_jumpType) {
		this.s_jumpType = s_jumpType;
	}
}
