package cn.myapps.run;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.data.jpa.JpaRepositoriesAutoConfiguration;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

@SpringBootApplication(exclude = { DataSourceAutoConfiguration.class, JpaRepositoriesAutoConfiguration.class })
@ComponentScan(basePackages = {  "cn.myapps.common.util","cn.myapps.conf",
		"cn.myapps.email.controller","com.teemlink.email","cn.myapps.*",
		"cn.myapps.email.**.service"
		})
@EnableFeignClients(basePackages = "cn.myapps.conf")
@EntityScan(basePackages= {"com.teemlink.email"})
@EnableJpaRepositories(basePackages= {"com.teemlink.email.**.dao"})
@EnableDiscoveryClient
public class EmailApp {

	public static void main(String[] args) {
		try{
			SpringApplication.run(EmailApp.class, args);
		}catch (Exception e){
			e.printStackTrace();
		}
	}

}
