import instance from './ajax';

/**
 * 获取模块表单列表
 */
export const getModuleFormList = (params, { onSucess, onError }) => {
  instance
    .get(contextPath + "/designtime/applications/modules/" + params.moduleId + "/forms?name=" + params.name+ "&description=" + params.description + "&type=" + params.type + "&pageNo=" + params.pageNo + "&linesPerPage=" + params.linesPerPage)
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * 删除表单
 */
export const deleteModuleForm = (multipleSelectionId) => {
  return instance({
    url: contextPath + "/designtime/applications/modules/forms",
    method: "delete",
    data: multipleSelectionId,
  })
};

/**
 * 一键生成视图
 */
export const generateView = (id, { onSucess, onError }) => {
  instance({
    url: contextPath + "/designtime/applications/modules/views?formId=" + id,
    method: "POST",
  })
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * 保存新建表单
 */
export const createForms = (params, { onSucess, onError }) => {
  instance({
    url: contextPath + "/designtime/applications/" + params.appId + "/modules/" + params.moduleId + "/forms",
    method: "POST",
    data: params,
  })
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * 更新表单
 */
export const updateForm = (params, { onSucess, onError }) => {
  instance({
    url: `${contextPath}/designtime/applications/${params.appId}/modules/${params.moduleId}/forms/${params.id}`,
    method: "PUT",
    data: params,
  })
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * 获取表单操作列表
 */
export const getFormActivityList = (params, { onSucess, onError }) => {
  instance
    .get(contextPath + "/designtime/applications/modules/forms/" + params.id + "/activitys")
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * 删除表单操作列
 */
export const deleteOperationColumn = (multipleSelectionId) => {
  return instance({
    url: contextPath + "/designtime/applications/modules/forms/activitys",
    method: "delete",
    data: multipleSelectionId,
  })
};

/**
 * 更新表单操作
 */
export const updateOperationColumn = (params, data, { onSucess, onError }) => {
  instance({
    url: contextPath + "/designtime/applications/" + params.appId + "/modules/forms/" + params.formId + "/activitys/" + params.activityId,
    method: "PUT",
    data: data,
  })
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * 新建表单操作
 */
export const addOperationColumn = (params, data, { onSucess, onError }) => {
  instance({
    url: contextPath + "/designtime/applications/" + params.appId + "/modules/forms/" + params.formId + "/activitys",
    method: "POST",
    data: data,
  })
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * 获取表单详情
 */
export const getModuleForm = (formId, { onSucess, onError }) => {
  instance
    .get(contextPath + "/designtime/applications/modules/forms/" + formId)
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * 获取字段列表
 */
export const getFieldData = (formId, { onSucess, onError }) => {
  instance
    .get(contextPath + "/designtime/applications/modules/forms/" + formId + "/fields")
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * 获取表单清除数据字段列表
 */
export const getClearFieldData = (formId) => {
  return instance({
    url: contextPath + "/designtime/applications/modules/forms/" + formId + "/clearFields",
    method: 'get'
  })
};

/**
 * **清除表单字段数据**
 */
export const handleClearFieldData = (multipleSelectionfieldId, formId) => {
  return instance({
    url: contextPath + "/designtime/applications/modules/forms/cleardata?formId=" + formId,
    method: "post",
    data: multipleSelectionfieldId,
  })
};

/**
 * 获取摘要列表
 */
export const getSummarysListData = (params, { onSucess, onError }) => {
  instance
    .get(contextPath + "/designtime/applications/" + params.appId + "/summarys?formId=" + params.id + "&pageNo=1&linesPerPage=10000")
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * 删除摘要列
 */
export const deleteSummarys = (multipleSelectionSummarysId) => {
  return instance({
    url: contextPath + "/designtime/applications/summarys",
    method: "delete",
    data: multipleSelectionSummarysId,
  })
};

/**
 * 获取摘要详情
 */
export const getFormValueStoreFields = (params, { onSucess, onError }) => {
  instance
    .get(contextPath + "/designtime/applications/getFormValueStoreFields/" + params.id)
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * 新建摘要
 */
export const createSummarys = (params) => {
  return instance({
    url: contextPath + "/designtime/applications/" + params.appId + "/summarys",
    method: "post",
    data: params,
  })
};

/**
 * 更新摘要
 */
export const updateSummarys = (params) => {
  return instance({
    url: contextPath + "/designtime/applications/summarys",
    method: "put",
    data: params,
  })
};

/**
 * 创建菜单
 */
export const createMenu = (menuParams, params, { onSucess, onError }) => {
  instance({
    url: contextPath + "/designtime/applications/" + params.appId + "/form/" + params.id + "/menus",
    method: "POST",
    data: menuParams,
  })
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};



/**
 * 重置字段编号
 */
export const reqResetFieldNumber = ({ onSucess, onError }) => {
  instance
    .get(contextPath + "/designtime/applications/modules/forms/getSequence")
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * 获取数据表名称映射
 */
export const reqDbTableMapping = (params, { onSucess, onError }) => {
  instance
    .get(contextPath + "/designtime/applications/modules/forms/dataBaseTableMap?applicationId=" + params.appId)
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * 获取数据库列名称映射
 */
export const getDbColumnMapping = (params, { onSucess, onError }) => {
  instance
    .get(contextPath + "/designtime/applications/modules/forms/dataBaseColumnMap?applicationId=" + params.appId + "&tableName=" + params.tableName)
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};

/**
 * 映射表单同步数据
 */
export const reqSynchronousDBData = (params, { onSucess, onError }) => {
  instance({
    url: `${contextPath}/designtime/applications/modules/forms/synchronouslyData?formId=${params.id}&tableName=${params.tableName}&domainId=${params.domainId}`,
    method: "POST",
    data: params,
  })
    .then(function(response) {
      if (onSucess) onSucess(response);
    })
    .catch(function(error) {
      if (onError) onError(error);
    });
};
