class Api {
	
	constructor() {
		this.contextPath = contextPath;
	}
	
	/**
     * 获取模板
     * @param tmlName 需要请求的模板名称
	 * @return 返回$.Deferred实例，用于后面调用done,fail方法
     */
	getTemplete(tmlName) {
		if(typeof tmlName == 'string' && tmlName.indexOf('.html') == -1) {
			tmlName += '.html';
		}
		
		return $.ajax({
			async: true,
			type: 'GET',
			url: 'tpl/' + tmlName
		});
	}
	
	/**
     * 获取json配置文件，主要是获取下拉列表的各项选择值
	 * @return 返回ajax异步实例，用于后面调用done,fail方法
     */
	getJSON() {
		return $.ajax({
			async: true,
			type: "GET",
			url: 'json/config.json',
			dataType: 'json',
            contentType: 'application/json'
		});
	}

	/**
	 * 获取报表的基本配置信息(所选数据源，所填的查询语句等等)
	 * @return 返回$.Deferred实例，用于后面调用done,fail方法
	 */
	getReportBasicConf(params) {
		let result = '';

		 $.ajax({
			async: false,
			type: 'POST',
			url: "/"+this.contextPath+`/designtime/applications/${params.appId}/reports/getQueryColumnInfos?type=${params.dataSourceType}&reportId=${params.reportId}&dataSourceName=${params.dataSourceName}&viewId=${params.viewId}`,
			data:params.data,
			dataType: 'json'
		}).done((data) => {
			 if(data.resultCode == 1) {
				 result = {'success': data.queryColumnInfos};
			 } else {
				 result =  {'error': data.msg};
			 }
		 });

		 return result;
	}

	/**
	 * 获取对应的xml配置文件，用以反解析生成报表元素
	 * @return 返回xml字符串
	 */
	getXMLConf(fileId) {
		let xml = '';

		$.ajax({
			async: false,
			type: 'GET',
			url: "/"+this.contextPath+`/designtime/applications/reports/getJrxmlString?id=${fileId}`,
			dataType: 'json'
		}).done((data) => {
			if(data.errcode == 0) {
				xml = data.data;
			}
		});
		//console.log(xml)
		return xml;
	}
	/**
	 * 获取图片路径
	 * 传入拿到的二进制数据流
	 * @return 返回绝对路径
	 * 
	 */
	getImgAddr(file){
		let src="";
		$.ajax({
			url:"/"+this.contextPath+'/designtime/applications/reports/uploadImageFile',
			dataType:'json',
			type:'POST',
			async: false,
			data: file,
			processData : false, // 使数据不做处理
			contentType : false, // 不要设置Content-Type请求头
			success: function(data){
				console.log(data);
				src=data.data;
			},
			error:function(response){
				console.log(response);
			}
   		 });

		return src;
		
	}

	/**
     * 获取所有的报表名称和id
     */
	getSubReport(parentId) {
		
		return $.ajax({
			async: false,
			type: 'GET',
			url: `/${this.contextPath}/designtime/applications/modules/${parentId}/reports?searchword=&pageNo=1&linesPerPage=10000000`
		});
	}

	/**
     * 返回报表的jasper文件路径
     */
	getReportPath(reportId) {
		return $.ajax({
			async: false,
			type: 'GET',
			url: `/${this.contextPath}/designtime/applications/reports/getReportJasperPath?reportId=${reportId}`
		});
	}
	

}
// processData: false,
// ajax({
// 	async: false,
// 	type: 'POST',
// 	url: this.contextPath+'/core/report/fileUpload.action',
// 	//contentType:'multipart/form-data',//multipart/form-data | application/json
// 	// headers: {'Content-Type': 'application/json'},
// 	data: file,
// 	// 告诉jQuery不要去处理发送的数据，用于对data参数进行序列化处理 这里必须false
// 	processData : false,
// 	// contentType: false,
// 	dataType: 'json',
// 	// processData: false,
//
//
// });
export default Api;