import Chunk from './Chunk';
import {Sequence} from '../../utility';
import {StaticText, Line, TextField, Rectangle, Ellipse, imgEle, CurrentDate, PageNumber, Chart,SubReport} from '../element';

class PageHeader extends Chunk {
	constructor(width, height) {
		super(width, height);
		this.element = [];
		this.id = "";
		this.scope = 'PageHeader';
		this.top = 240;
		this.width = this.reportWidth;
        this.defaultH = 120;
		this.height = 120;
		this.minHeight = 0;
		this._beforeMovePos = 0;
		this._beforeMoveHeight = 0;
		this.isSelectedBaseline = false;
		this.printScript = '';
		this.splitType = 'Stretch';
	}
	
	getClassName(){
		return 'PageHeader';
	}
	getChineseName(){
		return '页头';
	}
	/**
	 * @param g
	 */
	paint(g) {
		if(this.height<=3){
			this.top=this.top-this.height;
			this.height=0;
			return ;
		}
		if(!this.id) {
			this.id = Sequence.createUuid();
		}
		
		g.save();
		
		if(this.isSelectedBaseline) {
			g.setColor(Chunk.DEF_CURREDITCOLOR);
			g.drawLine(0, this.top, this.width, this.top);
			g.setColor(this.color);
		} else {
			g.setColor(this.color);
			g.drawLine(0, this.top, this.width, this.top);
		}
		
		g.setFont(this.font);
		g.textAlign('center');
		g.textBaseLine('middle');
		g.fillText(this.scope, this.width / 2, this.top - (this.height / 2));
		g.restore();
		
		if(this.element.length > 0) {
			for(let i = 0;i < this.element.length;i++) {
				this.element[i].paint(g);
			}
		}
	}
	
	toXML() {
		let str = '<pageHeader>\n';
		str += `<band height = "${parseInt(this.height)}" splitType = "${this.splitType}">\n`;
		if(this.printWhenExpression!=""){
			str +=`<printWhenExpression><![CDATA[`+this.printWhenExpression+`]]></printWhenExpression>`
		}
		if(this.element.length > 0 ) {
			for(let i = 0;i < this.element.length;i++) {
				str += this.element[i].toXML();
			}
		}
		str += '</band>\n';
		str += '</pageHeader>\n';
		
		return str;
	}

	parseXML(xmlNode) {
		//console.log(333)
		let elem = [];
		let h = 0;
		let id, splitType = '';
		let chart;
		const traversalNode = (xmlNode) => {
			//console.log(xmlNode);
			const { tagName } = xmlNode;
			//console.log(tagName);

			switch (tagName) {
				case 'printWhenExpression':
					this.printWhenExpression=xmlNode.textContent;
					break;
				case 'staticText':
					const staticText = new StaticText();
					staticText.parseXML(xmlNode);
					staticText.belong = this.getClassName();
					elem.push(staticText);
					break;
				case 'textField':

					const hasCurrentDate = xmlNode.textContent.indexOf("new java.util.Date()")==-1?false:true;
					const hasPageNumber = xmlNode.textContent.indexOf("$V{PAGE_NUMBER}")==-1?false:true;
					if(hasCurrentDate){
						const currentDate = new CurrentDate();
						currentDate.parseXML(xmlNode);
						currentDate.belong = this.getClassName();
						elem.push(currentDate);
					}else if(hasPageNumber){
						const pageNumber = new PageNumber();
						pageNumber.parseXML(xmlNode);
						pageNumber.belong = this.getClassName();
						elem.push(pageNumber);
					}else{
						const textField = new TextField();
						textField.parseXML(xmlNode);
						textField.belong = this.getClassName();
						elem.push(textField);
					}

					break;
				case 'line':
					const line = new Line();
					line.parseXML(xmlNode);
					line.belong = this.getClassName();
					elem.push(line);
					break;
				case 'rectangle':
					const rectangle = new Rectangle();
					rectangle.parseXML(xmlNode);
					rectangle.belong = this.getClassName();
					elem.push(rectangle);
					break;
                case 'ellipse':
                    const ellipse = new Ellipse();
                    ellipse.parseXML(xmlNode);
					ellipse.belong = this.getClassName();
                    elem.push(ellipse);
                    break;
				case 'image':
					console.log(xmlNode);
					const image = new imgEle();
					image.parseXML(xmlNode);
					image.belong = this.getClassName();
					elem.push(image);
					break;
				case 'pieChart':
					chart = new Chart();
					chart.chartType="pie";
					chart.src="../reportHtml/images/PieChart.png";
					chart.parseXML(xmlNode);
					chart.belong = this.getClassName();
					elem.push(chart);
					break;
				case 'barChart':
					chart = new Chart();
					chart.chartType="bar";
					chart.src="../reportHtml/images/BarChart.png";
					chart.parseXML(xmlNode);
					chart.belong = this.getClassName();
					elem.push(chart);
					break;
				case 'lineChart':
					chart = new Chart();
					chart.chartType="line";
					chart.src="../reportHtml/images/LineChart.png";
					chart.parseXML(xmlNode);
					chart.belong = this.getClassName();
					elem.push(chart);
					break;
				case 'subreport':
					let subReport = new SubReport();
					subReport.parseXML(xmlNode);
					subReport.belong = this.getClassName();
					elem.push(subReport);
					break;
				default:
					break;
			}
		};

        if(xmlNode.hasChildNodes() && xmlNode.children[0].tagName == 'band') {
            const bandNode = xmlNode.children[0];

            h = Number(bandNode.getAttribute('height'));
            splitType = bandNode.getAttribute('splitType');

            if(bandNode.hasChildNodes()) {
                for(let i = 0;i < bandNode.children.length;i++) {
                    traversalNode(bandNode.children[i]);
                }
            }
        }
		
		this.setProps({element: elem, height: h, id: id, splitType: splitType});

        return elem;
	}	
}

export default PageHeader;