﻿# Report Designer

## 目录
* [开发背景](#开发背景)
* [项目描述](#项目描述)
* [运行环境](#运行环境)
   * [node.js](#node.js)
   * [webpack](#webpack)
* [工作进度](#工作进度)
* [类图](#类图)
* [API接口](#API接口)
* [注意事项/建议](#注意事项/建议)

## 开发背景

由于公司现有报表设计器操作不便，采用的flash技术相对于目前来说维护成本过高，功能设计也不够完善，故经过一番准备后，决定开发新的报表设计器。

## 项目描述

本报表设计器主要是以拖拽控件到画布上然后通过配置各项属性从而实现用户自定义报表的功能。前端是以iReport设计器为参照制作实现，后台则是调用jasperreport接口进行xml解析获得报表。

## 运行环境

### node.js

本报表设计器在开发过程中使用了node.js平台的npm作为包管理工具，因此开发者的电脑上需要安装node.js并了解其运行原理([node官网](https://nodejs.org/zh-cn/))。安装完成后使用node -v查看安装的版本（如若安装依赖包时出现问题，则大概率为版本问题）。  
其基本命令可参考[npm基本使用教程](http://www.cnblogs.com/linjiqin/p/3765772.html)。

### webpack

本报表设计器需要使用webpack进行打包处理，其配置文件在项目根目录下的build目录，若是开发者想进行个性化配置，可自行更改配置文件。而若是要启动webpack进行打包，则需要看项目根目录package.json文件下的scripts字段，其中dev为开发环境，build为生产环境，watch为开发环境下实时代码更新，hot为开发环境下的热更新。具体使用可以在命令行下指向当前根目录后敲npm run 加上述几个单词便可运行(前提时需要有node环境，且通过npm下载了webpack)。

## 工作进度

报表面板的制作(√)<br />
基本组件的制作(√)<br />
属性面板的制作(iReport里有些还没理解的属性没办法添加，需后续开发者理解后添加实现)<br />
报表查看器面板的制作(大部分已经实现，基本上只剩下Variable和Paramters这两个树的制作)<br />
报表表达式的制作(面板做了一部分，但值的保存还没做)<br />
高级组件如image组件、交叉报表组件、子报表、table组件的制作(还未开展，其中image组件需要后台提供个上传接口)<br />

## 类图
![Image Text](./images/report.png)

注：该图片使用的是相对路径，位于项目根目录的images底下。

## API接口

常用的请求接口如下：

### getTemplete(tmlName)

请求链接： 'ReportDesign/tpl/' + tmlName

#### params

|名称 | 类型 | 备注 |
|-----|-----|-----------------------------|
|tmlName |string    |(必须)需要请求的HTML片段模板文件名 |

#### return

请求到的html片段，之后会用templete.js渲染到DOM上生成视图。

### getJSON()

请求链接：'ReportDesign/json/config.json'

#### params

|名称 | 类型 | 备注 |
|-----|-----|-----------------------------|

#### return

返回请求到的json配置文件，用于后续属性面板当中的下拉列表的选项值，此配置文件需要由前台编写。

### getReportBasicConf(name, sql, appId)

请求链接：项目名 + ‘/core/report/getquerycolumninfos’

#### paramas

|名称 | 类型 | 备注 |
|-----|-----|-----------------------------|
|name | string | 用户选的数据源 |
|sql | string | 用户填的sql语句 |
|appId | string | 软件ID |

#### return 
成功时，返回resultCode=1以及用户填写sql语句的列名以及后台给列的java类型。
如： data = {resultCode: 1， queryColumnInfos: {columnName: ..., columnClassName: ...]}
失败时，返回resultCode=0以及错误信息。
如：data = {resultCode:0, msg:...}

### getXMLConf(fileId)

请求链接：项目名 + '/core/report/getjrxml/'+fileId

#### params

|名称 | 类型 | 备注 |
|-----|-----|-----------------------------|
|fileId | string | 报表文件ID |

#### return

成功时，返回resultCode = 1以及xml字符串。
如：data = {resultCode:1, jrxmlString: 'xml'}
失败时，返回resultCode = 0以及错误信息。
如：data = {resultCode:0,msg:...}

注：至于报表设计器里的逻辑性方法在此不多赘述，可自行翻看对应文件了解其运作(有注释)。

## 注意事项/建议

1、后续的每一个功能开发都尽可能依照iReport的组件设计原理来设计（最好在实现前先熟悉该组件在iReport中的应用），除非是设计那边出了功能需求，否则尽可能参照iReport的实现原理。<br />
2、开发工具的选择上尽可能用webpack（纯前端）或者idea（需要和java后端协作），能够提高编码效率。<br />
3、开发过程中尽量保证结构符合规范、按需使用设计模式。<br />
4、md文档的查看和编写建议使用[StackEdit](https://stackedit.io/editor)或者在使用的开发工具里集成markdown插件。<br />