var path = require('path');
var webpack = require('webpack');
var ExtractTextPlugin = require("extract-text-webpack-plugin");
var HtmlWebpackPlugin = require('html-webpack-plugin');
// var BundleAnalyzerPlugin = require('webpack-bundle-analyzer').BundleAnalyzerPlugin;
var env = process.env.NODE_ENV === "production"
    ? "production"
    : "development";

var webpackConfig = {
    entry: {
        flowDiagram: './src/app.js'
    },
    output: {
        publicPath: '',
        filename: './script/[name].js',
        path: path.resolve(__dirname, '../')
    },
    module: {
        rules: [
            {
                test: /\.(jsx?|es6)$/,
                exclude: /node_modules/,
                loader: 'babel-loader',
                query: {
                    presets: ['env', 'stage-0']
                }
            }, {
                test: /\.(png|jpe?g|gif)(\?.*)?$/,
                use: [
                    {
                        loader: 'file-loader',
                        options: {
                            name: '[name].[ext]',
                            outputPath: './script/flowDiagram/'
                        }
                    }
                ]
            }
        ]
    },
    plugins: [
        new webpack.DefinePlugin({
            'process.env': {
                NODE_ENV: "\'" + env + "\'"
            }
        }),
        new webpack
            .optimize
            .OccurrenceOrderPlugin(),
    ],
    resolve: {
        extensions: [
            '.js',
            '.jsp',
            '.jsx',
            'json',
            '.css',
            '.scss'
        ]
    }
}

if (env == "production") {
    process.env.BABEL_ENV = 'production';
    webpackConfig
        .plugins
        .push(new webpack.optimize.UglifyJsPlugin({
            compress: {
                warnings: false
            },
            comments: false,
            sourceMap: false
        }));
} else {
    process.env.BABEL_ENV = 'development';
    webpackConfig.devtool = 'cheap-module-eval-source-map';
}

module.exports = webpackConfig;