import AbstractField from "./AbstractField";
import { Sequence } from "../../utility";

class SplitField extends AbstractField{
    constructor(container) {
        super();
        this.scope="splitField"
        this.container = container;
        this.htmlDOM=null;
        this.className="baseField";
        this.propValues.id = Sequence.createUuid();
        this.html=`<div style="padding: 5px 0;line-height: 20px;color: #3d464d;font-weight: 600;">
        <span  class="baseLabel-title" style="font-size: 14px;color: #3d464d;">分割行</span>
        </div><div class="baseCon fieldId"  fieldid='${this.propValues.id}' style="">
        <hr /></div>`
        
        this.propValues.name="分割行"+window.formApp.formPanel.propValues.nameIndex;
        this.propValues.height = ""; // 高度
        this.propValues.titleScript =""; // 标题

        this.propValues.hiddenscript = ""; //隐藏条件脚本
        this.propValues.hiddenvalue = ""; //隐藏时显示值

    }
    
    getPropsDesc() {
        return {
            "base":['myselfrows','name', 'height', 'titleScript' ],
            "hidden":['hiddenscript','hiddenvalue'],
        }
    }
    
}
export default SplitField;