import FormPanel from "./form/FormPanel";
import PropsPanel from "./form/PropsPanel";

class FormApp {
  constructor(formContainer, propsContainer) {
    this.formContainer = formContainer;
    //this.container = container;
    this.formPanel = null;
    this.allElements = [];
    this.propsContainer=propsContainer;
    this.placeholderDom = document.createElement("DIV");
  }
  /**
   * 初始化init */
  init(){
    let str = window.location.search.replace(/\?/, "").split("&");
    window.params={};
		str.forEach((el)=>{
			window.params[el.split("=")[0]] = el.split("=")[1];
		});
    this.formPanel = new FormPanel(this.formContainer);
    this.formPanel.height = this.formContainer.getBoundingClientRect().height;
    this.formPanel.rendTo();
    // this.allElements=this.formPanel;
    this.propsPanel = new PropsPanel(this.propsContainer);
    this.propsPanel.render();
    this.placeholderDom.setAttribute("class","placeholder");
    this.bindEvent();
    this.load();
  }
  /**
   * 绑定事件
   */
  bindEvent(){
    let that=this;
    document.getElementById("save_btn").addEventListener('click',()=>{
      let result=this.formPanel.checkField() && this.formPanel.checkConProp(); // 校验元素和容器
      
      if(result)
      {
        let div=document.createElement("div");
        div.innerHTML=that.formContainer.innerHTML
        // for(let i=0;i<div.getElementsByClassName("baseCon").length;i++){
        //   div.getElementsByClassName("baseCon")[i].innerHTML="";
        //   let input = document.createElement("input");
        //   input.setAttribute("fieldId",div.getElementsByClassName("baseCon")[i].getAttribute("fieldId"));
        //   div.getElementsByClassName("baseCon")[i].parentElement.appendChild(input);
        //   div.getElementsByClassName("baseCon")[i].parentElement.removeChild(div.getElementsByClassName("baseCon")[i])
        //   i--;
        // }
        for(let i=0;i<div.getElementsByClassName("tab-content").length;i++){
          div.getElementsByClassName("tab-content")[i].innerHTML="";
          
        }
        window.parent.formFormat = div.innerHTML.replace(/&amp;/g, '&');
        
      }
      else
        window.parent.formFormat = false;
    })
    document.getElementById("resetid").addEventListener("click",()=>{
      this.resetAllId();
    })
  }
  /**
   * 初始化load面板
   */
  load(){
    let params = window.params;
    // if(params.formid){
      try{
        this.propsPanel.api.getFormDetail(params.formid).then(result=>{
          let div = document.createElement("DIV");
          div.innerHTML= JSON.parse(result).data.templatecontext;
          // this.formPanel.panel.innerHTML = JSON.parse(result).data.templatecontext
          this.parseHtml(div);
          this.formPanel.resetAllElemandContainer();
        }).catch(err => {
          console.log(err)
        })
      }catch(e){
        console.log(e);
      }
    // }
  }
  /**
   * 初始化的时候解析html
   * @param  html 
   */
  parseHtml(html){
    let root=html;
    const traversalNode = (htmlNode) => {
      //这里对formpanel的样式和属性进行解析保存

      this.formPanel.parseSelfProp(htmlNode);

      //这是最外层面板容器了。从这里开始对单个节点调用parsehtml方法
      this.formPanel.parseHtml(htmlNode,this.formPanel.htmlDOM)

    }
    
    if(root.hasChildNodes()) {
        for(let i = 0;i < root.children.length;i++) {
            traversalNode(root.children[i]);
        }
    }
  }
  //对脚本编辑器返回的值做一个处理，
  setScript(id,name,val){
    for(let i=0;i<this.allElements .length;i++){
      if(this.allElements[i].propValues.id==id){
        if(this.allElements[i].scope=='tabField'){
          let index = parseInt(name.replace(/hiddenScript|readOnlyScript|hiddenPrintScript|selectRefreshScript/,""));
         if(name=='selectedscript'){index=0}      
          let key = name.replace(/[0-9]/g,"");
          let rel=[...this.allElements[i].propValues.relstr];
          rel[index][key]=val;
          this.allElements[i].setPropValues({"relstr":rel})
          //tiga 9/13
          if(name=='selectedscript'){
            let obj={}
            obj[name]=val
            this.allElements[i].setPropValues(obj)
          }
        }else{
           let obj={};
          obj[name]=val;
          this.allElements[i].setPropValues(obj)
        }
       
      }
    }
  }
  //重置所有的id包括formpanel的
  resetAllId(){
    //formpanel的
    window.formApp.formPanel.resetId();
    //allElement
    window.formApp.allElements.forEach(elm=>{
      elm.resetId();
    })
    //container
    window.formApp.formPanel.childs.forEach(el=>{
      if(el.scope=='container'){
        el.resetId();
      }
    })
  }
}
export const render = (formContainer,propsContainer) => {
  window.formApp=new FormApp(formContainer,propsContainer)
  window.formApp.init();
};
