import MasterSheet from '../excelmapping/MasterSheet';
import DetailSheet from '../excelmapping/DetailSheet';
import Column from '../excelmapping/Column';
import Relation from '../excelmapping/Relation';
import StringUtil from '../utility/StringUtil';

class XMLOperate {
  constructor(xml, diagram) {
    this.xml = xml;
    this.flowDiagram = diagram;
    this.flowDiagram._elems = [];
  }

  setElementProps(xmlNode, element) {
    const { tagName } = xmlNode;
    // console.log(tagName)
    // let parentTagName = xmlNode.parentElement.tagName;
    const tagValue = xmlNode.childNodes[0] ? xmlNode.childNodes[0].nodeValue : '';

    // switch(parentTagName){
    //     //FlowDiagram
    //     case 'cn.myapps.runtime.workflow.element.FlowDiagram':
    //         if((tagName == 'width' && tagValue > element.width)
    //           || (tagName == 'height' && tagValue > element.height)){
    //             element[tagName] = tagValue
    //         }
    //         break;
    //     default:
    //         element[tagName] = tagValue;
    //         break;
    // }
    const elementObj = element;
    const type = typeof elementObj[tagName];
    const value = StringUtil.dencodeHTML(tagValue);
    if (type === 'number') {
      elementObj[tagName] = parseInt(value, 10);
    } else if (type === 'boolean') {
      elementObj[tagName] = value === 'true';
    } else {
      elementObj[tagName] = value;
    }
  }


  parserXML() {
    const traversalNode = (xmlNode, element) => {
		//console.log(this.xml.children[0]);
		//console.log(xmlNode.hasChildNodes());
      const { tagName } = xmlNode;
		//console.log(tagName);
      if (xmlNode.hasChildNodes() && xmlNode.children.length > 0) { // 节点时
        let subElement = null;
        let isFlowDiagramElem = true;
        switch (tagName) {
          // ExcelMappingDiagram
          case 'cn.myapps.runtime.dynaform.dts.excelimport.ExcelMappingDiagram':
            // subElement = new FlowDiagram(canvas);
            subElement = element;
            break;
            // 主表
          case 'cn.myapps.runtime.dynaform.dts.excelimport.MasterSheet':
            subElement = new MasterSheet(this.flowDiagram);
            break;
            // 子表
          case 'cn.myapps.runtime.dynaform.dts.excelimport.DetailSheet':
            subElement = new DetailSheet(this.flowDiagram);
            break;
			// 行
          case 'cn.myapps.runtime.dynaform.dts.excelimport.Column':
            subElement = new Column(this.flowDiagram);
            break;
            // 线
          case 'cn.myapps.runtime.dynaform.dts.excelimport.Relation':
            subElement = new Relation(this.flowDiagram);
            break;
          default:
            isFlowDiagramElem = false;
            break;
        }
        if (isFlowDiagramElem && tagName !== 'cn.myapps.runtime.dynaform.dts.excelimport.ExcelMappingDiagram') {
          element._elems.push(subElement);
        }

        if (isFlowDiagramElem) {
          for (let i = 0; i < xmlNode.children.length; i += 1) {
            traversalNode(xmlNode.children[i], subElement);
          }
        }
      } else { // 属性时
        this.setElementProps(xmlNode, element);
      }
    };

    traversalNode(this.xml.children[0], this.flowDiagram);

    return this.flowDiagram;
  }
}

export default XMLOperate;
