import request from "@/api/request";
import requestAccess from "@/api/requestAccess";

//查询电子围栏
// {
//   "pageIndex": 0,
//   "pageSize": 0,
//   "stationId": "string"
// }
export function searchRail(params) {
  return request({
    url: "/security-station-rails/search",
    method: "POST",
    data: params,
  });
}

export function searchRailAccess(params) {
  return requestAccess({
    url: "/security-station-rails/search",
    method: "POST",
    data: params,
  });
}

//创建电子围栏
export function createRail(params) {
  return request({
    url: "/security-station-rails",
    method: "POST",
    data: params,
  });
}
export function createRailAccess(params) {
  return requestAccess({
    url: "/security-station-rails",
    method: "POST",
    data: params,
  });
}

//修改电子围栏
export function updateRail(params) {
  return request({
    url: "/security-station-rails/" + params.id,
    method: "PUT",
    data: params,
  });
}
export function updateRailAccess(params) {
  return requestAccess({
    url: "/security-station-rails/" + params.id,
    method: "PUT",
    data: params,
  });
}

//删除电子围栏
export function deleteRail(params) {
  return request({
    url: "/security-station-rails/" + params.id,
    method: "DELETE",
    data: params,
  });
}
export function deleteRailAccess(params) {
  return requestAccess({
    url: "/security-station-rails/" + params.id,
    method: "DELETE",
    data: params,
  });
}

//获取电子围栏详细信息
export function getRailDetail(railId) {
  return request({
    url: "/security-station-rails/" + railId,
    method: "GET",
  });
}
export function getRailDetailAccess(railId) {
  return requestAccess({
    url: "/security-station-rails/" + railId,
    method: "GET",
  });
}
