import { getAllStationTypes } from "@/api/security-station-controller";

const app = {
  state: {
    settings: {},
    showHeatmap: false,
    showInitLoading: true,
    rail: {
      longitude: undefined,
      latitude: undefined,
      distance: 100,
    },
    rightType: "crossStation",
    crossStation: false,
    stationListLength: {
      security: 0,
      population: 0,
      temporarySecurity: 0,
    },
    stationTypes: [],
  },
  getters: {
    settings: (state) => {
      const url = process.env.NODE_ENV === "production" ? "https://v5qy.baibaodun.cn" : "https://v5qy.te.baibaodun.com.cn";
      return {
        ...state.settings,
        logo: `${url}/obpm${state.settings.logo}`,
      };
    },
    showHeatmap: (state) => state.showHeatmap,
    showInitLoading: (state) => state.showInitLoading,
    rail: (state) => state.rail,
    rightType: (state) => state.rightType,
    crossStation: (state) => state.crossStation,
    stationListLength: (state) => state.stationListLength,
  },
  mutations: {
    SET_APP_SETTING(state, setting) {
      state.settings = { ...state.settings, ...setting };
    },
    TOGGLE_SHOW_HEATMAP(state) {
      state.showHeatmap = !state.showHeatmap;
    },
    SET_APP_LOADING(state, visible) {
      state.showInitLoading = visible;
    },
    SET_RAIL(state, rail) {
      state.rail = { ...state.rail, ...rail };
    },
    SET_RIGHT_TYPE(state, rightType) {
      state.rail = rightType;
    },
    TOGGLE_CROSS_STATION(state) {
      state.crossStation = !state.crossStation;
    },
    SET_STATION_LIST_LENGTH(state, { security, population, temporarySecurity }) {
      state.stationListLength = {
        ...state.stationListLength,
        security,
        population,
        temporarySecurity,
      };
    },
    SET_STATION_TYPES(state, payload) {
      state.stationTypes = [...payload];
    },
  },
  actions: {
    setRail(context, rail) {
      context.commit("SET_RAIL", rail);
    },
    setRightType(context, rightType) {
      context.commit("SET_RIGHT_TYPE", rightType);
    },
    toggleCrossStation(context) {
      context.commit("TOGGLE_CROSS_STATION");
    },
    setStationListLength(context, { security, population, temporarySecurity }) {
      context.commit("SET_STATION_LIST_LENGTH", { security, population, temporarySecurity });
    },
    async setAllStationTypes({ commit }) {
      const stationTypes = await getAllStationTypes({
        deskTypes: ["TemporarySecurity"],
      });
      commit("SET_STATION_TYPES", stationTypes);
      return Promise.resolve(stationTypes);
    },
  },
};

export default app;
