import Vue from "vue";
import Vuex from "vuex";
import getters from "./getters";
import conversation from "./modules/conversation";
import user from "./modules/user";
import group from "./modules/group";
import video from "./modules/video";
import app from "./modules/app";
import trtc from "@/store/modules/trtc";
import { Dialog } from "vant";

Vue.use(Vuex);

export default new Vuex.Store({
  getters,
  state: {
    current: Date.now(), // 当前时间
    intervalID: 0,
    message: undefined,
    placeKeywords: "",
    poiList: [],
    visualVisible: false,
    cachedViews: [],
    visitedViews: [],
  },
  mutations: {
    SET_POI_LIST(state, list) {
      console.log("poiList", list);
      state.poiList = list;
    },
    SET_PLACE_KEYWORDS(state, keywords) {
      state.placeKeywords = keywords;
    },
    startComputeCurrent(state) {
      state.intervalID = setInterval(() => {
        state.current = Date.now();
      }, 500);
    },
    showMessage(state, options) {
      if (state.message) {
        state.message.close();
      }
      console.log("showMessage", options);
      // TODO: show message
      state.message = Dialog.alert({
        message: options.message,
      });
    },
    SET_VISUAL_VISIBLE(state, visible) {
      state.visualVisible = visible;
    },
    ADD_VISITED_VIEWS: (state, view) => {
      if (state.visitedViews.some((v) => v.path === view.path)) return;
      state.visitedViews.push({
        name: view.name,
        path: view.path,
        title: view.meta.title || "no-name",
      });
      if (view.meta?.cache) {
        state.cachedViews.push(view.name);
      }
    },
  },
  actions: {
    addVisitedViews({ commit }, view) {
      return new Promise((resolve) => {
        commit("ADD_VISITED_VIEWS", view);
        resolve();
      });
    },
  },
  modules: {
    conversation,
    user,
    group,
    video,
    app,
    trtc,
  },
});
