package com.bcxin.sync.service.tuoluojiang;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.dao.mapper.tuoluojiang.EbEnterpriseRoleUserMapper;
import com.bcxin.sync.entity.tuoluojiang.EbEnterpriseRoleUserEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * description：陀螺匠-企业角色用户表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class EbEnterpriseRoleUserService extends ServiceImpl<EbEnterpriseRoleUserMapper, EbEnterpriseRoleUserEntity> {

    /**
     * description：创建用户角色
     * author：linchunpeng
     * date：2025/2/18
     */
    public EbEnterpriseRoleUserEntity roleUserCreate(Long entid, Long roleId, Long adminId) {
        LambdaQueryChainWrapper<EbEnterpriseRoleUserEntity> lqw = this.lambdaQuery();
        lqw.eq(EbEnterpriseRoleUserEntity::getEntid, entid);
        lqw.eq(EbEnterpriseRoleUserEntity::getRoleId, roleId);
        lqw.eq(EbEnterpriseRoleUserEntity::getUserId, adminId);
        List<EbEnterpriseRoleUserEntity> list = lqw.list();
        if (CollectionUtil.isNotEmpty(list)) {
            return list.get(0);
        }
        EbEnterpriseRoleUserEntity entity = new EbEnterpriseRoleUserEntity();
        entity.setEntid(entid);
        entity.setRoleId(roleId);
        entity.setUserId(adminId);
        entity.setStatus(1);
        return entity;
    }

    /**
     * description：创建并保存用户角色
     * author：linchunpeng
     * date：2025/2/18
     */
    @Transactional
    public void roleUserCreateAndSave(Long entid, Long roleId, Long adminId) {
        EbEnterpriseRoleUserEntity entity = this.roleUserCreate(entid, roleId, adminId);
        this.saveOrUpdate(entity);
    }

}