package com.bcxin.sync.service.tenant;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.common.utils.DateUtil;
import com.bcxin.sync.dao.mapper.tenant.TlkAttendanceSiteBaseInfoMapper;
import com.bcxin.sync.entity.tenant.TlkAttendanceSiteBaseInfoEntity;
import com.bcxin.sync.service.RedisCache;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * description：智能人事-驻勤点表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class TlkAttendanceSiteBaseInfoService extends ServiceImpl<TlkAttendanceSiteBaseInfoMapper, TlkAttendanceSiteBaseInfoEntity> {

    @Autowired
    private RedisCache redisCache;

    /**
     * description：根据组织id，获取有效的驻勤点列表
     * author：linchunpeng
     * date：2025/1/9
     */
    public List<TlkAttendanceSiteBaseInfoEntity> getEffectiveListByOrganizationId(String organizationId) {
        LambdaQueryChainWrapper<TlkAttendanceSiteBaseInfoEntity> lqw = this.lambdaQuery();
        lqw.eq(TlkAttendanceSiteBaseInfoEntity::getDomainid, organizationId);
        lqw.ge(TlkAttendanceSiteBaseInfoEntity::getItemAttendanceEndDate, cn.hutool.core.date.DateUtil.offsetDay(new Date(), -1));
        lqw.isNotNull(TlkAttendanceSiteBaseInfoEntity::getItemAttendanceSiteName);
//        lqw.orderByAsc(TlkAttendanceSiteBaseInfoEntity::getItemAttType);
        return lqw.list();
    }

    /**
     * description：根据组织id列表，获取前一天失效的驻勤点列表
     * author：linchunpeng
     * date：2025/1/9
     */
    public List<TlkAttendanceSiteBaseInfoEntity> getYesterdayLoseEffectivenessByOrganizationIdList(List<String> organizationIdList) {
        LambdaQueryChainWrapper<TlkAttendanceSiteBaseInfoEntity> lqw = this.lambdaQuery();
        lqw.in(TlkAttendanceSiteBaseInfoEntity::getDomainid, organizationIdList);
        Date now = new Date();
        //昨天天0点
        Date yesterdayZeroHour = DateUtil.getBeforeNumDayZeroTime(now, 1);
        //今天0点
        Date todayZeroHour = DateUtil.getDateZeroTime(now);
        //结束时间 >= 昨天0点
        lqw.ge(TlkAttendanceSiteBaseInfoEntity::getItemAttendanceEndDate, yesterdayZeroHour);
        //结束时间 < 今天0点
        lqw.lt(TlkAttendanceSiteBaseInfoEntity::getItemAttendanceEndDate, todayZeroHour);
        lqw.isNotNull(TlkAttendanceSiteBaseInfoEntity::getItemAttendanceSiteName);
        return lqw.list();
    }

    /**
     * description：根据驻勤点id，获取驻勤点的类型
     * author：linchunpeng
     * date：2025/3/13
     */
    public String getItemAttType(String attendanceSiteId) {
        String key = "data-sync:attendance-site:att-type:" + attendanceSiteId;
        Object value = redisCache.getCacheObject(key);
        if (value != null) {
            return value.toString();
        }
        TlkAttendanceSiteBaseInfoEntity attendanceSiteBaseInfo = this.getById(attendanceSiteId);
        redisCache.setCacheObject(key, attendanceSiteBaseInfo.getItemAttType(), 7, TimeUnit.DAYS);
        return attendanceSiteBaseInfo.getItemAttType();
    }
}