package com.bcxin.sync.service.tenant;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.dao.mapper.tenant.TenantOrganizationsMapper;
import com.bcxin.sync.entity.tenant.TenantOrganizationsEntity;
import com.bcxin.sync.entity.tuoluojiang.EbEnterpriseEntity;
import com.bcxin.sync.service.RedisCache;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.concurrent.TimeUnit;

/**
 * description：智能人事-组织表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class TenantOrganizationsService extends ServiceImpl<TenantOrganizationsMapper, TenantOrganizationsEntity> {

    @Autowired
    private RedisCache redisCache;

    /**
     * description：通过组织id，获取level
     * author：linchunpeng
     * date：2024/12/31
     */
    public Integer getLevelByOrgId(String orgId) {
        String key = "data-sync:org:level:" + orgId;
        Object value = redisCache.getCacheObject(key);
        if (value != null) {
            return Integer.parseInt(value.toString());
        }
        TenantOrganizationsEntity entity = this.getById(orgId);
        if (entity != null) {
            redisCache.setCacheObject(key, entity.getLevel(), 30, TimeUnit.MINUTES);
            return entity.getLevel();
        }
        return null;
    }

}