package com.bcxin.sync.service.jvs;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.configs.SyncConfig;
import com.bcxin.sync.dao.mapper.jvs.SysUserInfoMapper;
import com.bcxin.sync.dtos.response.BcxEmployeeResponse;
import com.bcxin.sync.entity.jvs.SysUserInfoEntity;
import com.bcxin.sync.entity.jvs.SysUserTenantEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * description：jvs-用户表
 * author：linchunpeng
 * date：2025/2/10
 */
@Slf4j
@Service
public class SysUserInfoService extends ServiceImpl<SysUserInfoMapper, SysUserInfoEntity> {

    @Autowired
    private SyncConfig syncConfig;
    @Autowired
    private SysUserTenantService sysUserTenantService;
    @Autowired
    private SysUserExtensionService sysUserExtensionService;

    /**
     * description：批量创建用户
     * author：linchunpeng
     * date：2025/2/11
     */
    @Transactional
    public String createBatch(List<BcxEmployeeResponse> employeeResponseList) {
        StringBuffer syncResult = new StringBuffer(256);
        AtomicInteger successAtomicCount = new AtomicInteger(0);
        log.info("批量创建用户，用户总数：{}", employeeResponseList.size());
        syncResult.append("\n批量创建用户，用户总数：").append(employeeResponseList.size());

        for (BcxEmployeeResponse response : employeeResponseList) {
            //执行同步用户数据
            try {
                this.create(response.getUserId(), response.getCredentialNumber(), response.getEmployeeName(), response.getTelephone());
                successAtomicCount.incrementAndGet();
            } catch (Exception e) {
                log.error("同步用户数据异常，用户数据：{}，{}", JSONObject.toJSONString(response), e.getMessage(), e);
                syncResult.append("\n同步用户数据异常，用户数据：").append(JSONObject.toJSONString(response)).append("，").append(e);
            }
        }
        return syncResult.toString();
    }


    /**
     * description：创建用户
     * author：linchunpeng
     * date：2025/2/11
     */
    @Transactional
    public SysUserInfoEntity create(String userId, String cardNo, String name, String mobile) {
        boolean isUpdate = true;
        SysUserInfoEntity entity = this.getById(userId);
        if (entity == null) {
            entity = new SysUserInfoEntity();
            entity.setId(userId);
            if (syncConfig.getIsDefaultPassword() != null && syncConfig.getIsDefaultPassword()) {

            } else {
                entity.setPassword("Abcd@123456");
            }
            isUpdate = false;
        }
        entity.setRealName(name);
        entity.setAccountName(cardNo);
        entity.setCancelFlag(0);

        this.saveOrUpdate(entity);
        if (isUpdate) {
            //同步修改职员信息
            List<SysUserTenantEntity> sysUserTenantEntityList = sysUserTenantService.getListByUserId(userId);
            if (CollectionUtil.isNotEmpty(sysUserTenantEntityList)) {
                for (SysUserTenantEntity sysUserTenantEntity : sysUserTenantEntityList) {
                    sysUserTenantEntity.setRealName(name);
//                    sysUserTenantEntity.setPhone(mobile);
                }
                sysUserTenantService.updateBatchById(sysUserTenantEntityList);
            }
        }
        //创建用户拓展
        sysUserExtensionService.create(userId, name);
        return entity;
    }

}
