package com.bcxin.sync.service.jvs;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.configs.SyncConfig;
import com.bcxin.sync.dao.mapper.jvs.SysTenantMapper;
import com.bcxin.sync.entity.jvs.SysTenantEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * description：jvs-公司租户表
 * author：linchunpeng
 * date：2025/2/10
 */
@Slf4j
@Service
public class SysTenantService extends ServiceImpl<SysTenantMapper, SysTenantEntity> {

    @Autowired
    private SyncConfig syncConfig;

    public SysTenantEntity getById(String id){
        if (id.equals(syncConfig.getJvsMainId())) {
            return super.getById("1");
        }
        return super.getById(id);
    }

    /**
     * description：创建企业
     * author：linchunpeng
     * date：2025/2/11
     */
    @Transactional
    public String create(String orgId, String name, String adminUserId, String adminUserAccount) {
        StringBuffer syncResult = new StringBuffer(64);
        SysTenantEntity entity = this.getById(orgId);
        if (entity == null) {
            entity = new SysTenantEntity();
            entity.setId(orgId);
            entity.setName(name);
            entity.setAdminUserId(adminUserId);
            entity.setAdminUserAccount(adminUserAccount);
            entity.setDelFlag("0");

            this.save(entity);
            log.info("创建企业成功");
            syncResult.append("\n创建企业成功");
        } else {
            log.info("企业已存在");
            syncResult.append("\n企业已存在");
        }
        return syncResult.toString();
    }

}
