package com.bcxin.sync.entity.tenant;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * description：设备录像表
 * author：linchunpeng
 * date：2025/5/28
 */
@Data
@TableName(value = "device_record", schema = "dispatch")
public class DeviceRecordEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    //主键id
    @TableId(value = "id")
    private Long id;

    @ApiModelProperty(value = "设备编号")
    private String deviceNo;

    @ApiModelProperty(value = "设备名称")
    private String deviceName;

    @ApiModelProperty(value = "设备类型，4-代表着华为云台摄像机")
    private Integer deviceType;

    @ApiModelProperty(value = "绑定类型，0-驻勤点；1-考场")
    private Integer bindType;

    @ApiModelProperty(value = "绑定数据源id")
    private String bindPlaceId;

    @ApiModelProperty(value = "绑定数据源")
    private String bindPlace;

    @ApiModelProperty(value = "绑定数据源所属的组织id")
    private String bindOrgId;

    @ApiModelProperty(value = "绑定数据源所属组织的监管机构id")
    private String bindSupDepartId;

    @ApiModelProperty(value = "录制开始时间")
    private Date startTime;

    @ApiModelProperty(value = "录制结束时间")
    private Date endTime;

    @ApiModelProperty(value = "时长，单位：秒")
    private Integer durationTime;

    @ApiModelProperty(value = "录制文件状态：1回放视频下载中，2下载完成 ，0下载失败")
    private Integer fileStatus;

    @ApiModelProperty(value = "下载次数")
    private Integer downloadCount;

    @ApiModelProperty(value = "录制的文件名")
    private String fileName;

    @ApiModelProperty(value = "录制文件的地址")
    private String fileUrl;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "修改时间")
    private Date updateTime;

}