package com.bcxin.sync.entity.datasync;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;

/**
 * description：数据同步-第三方页面配置表
 * author：linchunpeng
 * date：2025/4/8
 */
@Data
@TableName("third_page_setting")
public class ThirdPageSettingEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    //主键id
    @TableId(value = "id")
    private Long id;

    //页面id（项目id）
    private String pageId;

    //页面名称（项目名称）
    private String pageName;

    //页面类型，1赛演3d，2风评报告
    private Integer pageType;

    //页面原始地址
    private String pageOriginalUrl;

    //加密后id
    private String encodeId;

    //状态：1有效，0无效
    private Integer status;

    //授权类型：1，公开访问，2指定公司，3指定职员，4指定公司和职员
    private Integer authType;

    //授权组织id，;隔开
    private String authOrgIds;

    //授权职员id，;隔开
    private String authEmpIds;

}