package com.bcxin.sync.dtos.request;

import com.bcxin.sync.dtos.page.PageDomain;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;


@Data
public class DeviceRecordListRequest extends PageDomain {

    @ApiModelProperty(value = "设备编号")
    private String deviceNo;

    @ApiModelProperty(value = "设备名称")
    private String deviceName;

    @ApiModelProperty(value = "绑定数据源")
    private String bindPlace;

    @ApiModelProperty(value = "组织id列表，数组第一个值传*，则表示查询所有组织")
    private List<String> orgIdList;

    @ApiModelProperty(value = "监管机构id列表，数组第一个值传*，则表示查询所有监管机构")
    private List<String> supDepartIdList;

    @ApiModelProperty(value = "时间范围-开始，yyyy-MM-dd HH:mm:ss")
    private String startTimeStart;

    @ApiModelProperty(value = "时间范围-结束，yyyy-MM-dd HH:mm:ss")
    private String startTimeEnd;

}
