package com.bcxin.sync.consumer;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.sync.common.CommonConstant;
import com.bcxin.sync.common.emus.DataOperationType;
import com.bcxin.sync.common.emus.OpenType;
import com.bcxin.sync.common.utils.KafkaMessageUtil;
import com.bcxin.sync.dtos.kafka.message.TenantDepartmentEmployeeRelationsSyncMessage;
import com.bcxin.sync.service.datasync.OrganizationOpenService;
import com.bcxin.sync.service.tenant.TenantDepartmentsService;
import com.bcxin.sync.service.tuoluojiang.EbAdminService;
import com.bcxin.sync.service.tuoluojiang.EbEnterpriseService;
import com.bcxin.sync.service.tuoluojiang.EbFrameAssistService;
import com.bcxin.sync.service.tuoluojiang.EbFrameService;
import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Service;

/**
 * 职员kafka消息监听器
 */
@Slf4j
@Service
public class TenantDepartmentEmployeeRelationsKafkaConsumer {

    @Autowired
    private EbFrameService ebFrameService;
    @Autowired
    private EbFrameAssistService ebFrameAssistService;
    @Autowired
    private EbAdminService ebAdminService;
    @Autowired
    private EbEnterpriseService ebEnterpriseService;
    @Autowired
    private TenantDepartmentsService tenantDepartmentsService;
    @Autowired
    private OrganizationOpenService organizationOpenService;

    @KafkaListener(id = "bcx_data_sync_listener_tenant_department_employee_relations_to_tlj",
            topics = CommonConstant.TENANT_DEPARTMENT_EMPLOYEE_RELATIONS_KAFKA_TOPIC,
            groupId = "bcx_data_sync_tenant_department_employee_relations_to_tlj")
    public void bcxDataSyncTenantDepartmentEmployeeRelationsToTlj(ConsumerRecord<String, String> record, Acknowledgment ack) {
        TenantDepartmentEmployeeRelationsSyncMessage relations = KafkaMessageUtil.transferKafkaTenantDepartmentEmployeeRelationsSyncMessageRecord2Message(record);
        log.info("kafka监听tenant-department-employee-relations表，数据转化为：{}", JSONObject.toJSONString(relations));
        try {
            String organizationId = tenantDepartmentsService.getOrgIdByDepartmentId(relations.getAfterDeptId());
            boolean openAndEffective = organizationOpenService.isOpenAndEffective(organizationId, OpenType.TLJ.getCode());
            if (openAndEffective) {
                Long entid = ebEnterpriseService.getIdByOrgId(organizationId);
                if (entid != null) {
                    //有开通陀螺匠，才需要同步职员信息
                    log.info("组织id：{}，有开通陀螺匠，所以需要同步职员部门变更信息", organizationId);
                    if (relations.getOpType().getCode() == DataOperationType.DELETE.getCode()) {
                        ebFrameAssistService.frameAssistDelete(relations.getId());
                    } else {
                        Long adminId = ebAdminService.getIdByEmployeeId(relations.getEmployeeId(), entid);
                        if (adminId != null) {
                            ebFrameAssistService.frameAssistCreate(entid, relations.getAfterDeptId(), adminId,
                                    relations.getAfterLeaderType(), 1, relations.getId());
                            if (relations.getAfterLeaderType() != null && relations.getAfterLeaderType() == 1) {
                                //部门主管
                                ebFrameService.updateFrameUser(relations.getAfterDeptId(), adminId);
                            }
                        }
                    }
                }
            } else {
                log.info("组织id：{}，没有开通陀螺匠，所以不需要同步职员部门变更信息", organizationId);
            }
        } catch (Exception e) {
            log.error("kafka监听tenant-department-employee-relations表，异常：{}", e.getMessage(), e);
        }
        ack.acknowledge();
    }
}
