package com.bcxin.sync.consumer;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.sync.common.CommonConstant;
import com.bcxin.sync.common.emus.OpenType;
import com.bcxin.sync.common.utils.KafkaMessageUtil;
import com.bcxin.sync.dtos.kafka.message.ExternalMemberSyncMessage;
import com.bcxin.sync.dtos.response.BcxEmployeeResponse;
import com.bcxin.sync.entity.tenant.TenantDepartmentEmployeeRelationsEntity;
import com.bcxin.sync.entity.tuoluojiang.EbUserEntity;
import com.bcxin.sync.service.datasync.OrganizationOpenService;
import com.bcxin.sync.service.tenant.TenantEmployeesService;
import com.bcxin.sync.service.tuoluojiang.EbAdminService;
import com.bcxin.sync.service.tuoluojiang.EbEnterpriseRoleService;
import com.bcxin.sync.service.tuoluojiang.EbEnterpriseService;
import com.bcxin.sync.service.tuoluojiang.EbUserService;
import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;

/**
 * 分组成员kafka消息监听器
 */
@Slf4j
@Service
public class ExternalMemberKafkaConsumer {

    @Autowired
    private EbUserService ebUserService;
    @Autowired
    private EbAdminService ebAdminService;
    @Autowired
    private EbEnterpriseService ebEnterpriseService;
    @Autowired
    private EbEnterpriseRoleService ebEnterpriseRoleService;
    @Autowired
    private TenantEmployeesService tenantEmployeesService;
    @Autowired
    private OrganizationOpenService organizationOpenService;

    @KafkaListener(id = "bcx_data_sync_listener_external_members_to_tlj",
            topics = CommonConstant.EXTERNAL_MEMBERS_KAFKA_TOPIC,
            groupId = "bcx_data_sync_external_members_to_tlj")
    public void bcxDataSyncExternalMembersToTlj(ConsumerRecord<String, String> record, Acknowledgment ack) {
        ExternalMemberSyncMessage member = KafkaMessageUtil.transferKafkaMemberRecord2Message(record);
        log.info("kafka监听external_members表，数据转化为：{}", JSONObject.toJSONString(member));
        try {
            if (member != null && member.getReferenceType() == 0) {
                boolean openAndEffective = organizationOpenService.isOpenAndEffective(member.getReferenceNumber(), OpenType.TLJ.getCode());
                if (openAndEffective) {
                    Long entid = ebEnterpriseService.getIdByOrgId(member.getReferenceNumber());
                    if (entid != null) {
                        //有开通陀螺匠，才需要同步分组成员信息
                        log.info("组织id：{}，有开通陀螺匠，所以需要同步分组成员信息", member.getReferenceNumber());
                        List<BcxEmployeeResponse> employeeResponseList = tenantEmployeesService.getEmployeeResponseListByEmployeeIdList(Collections.singletonList(member.getMemberId()), null);
                        EbUserEntity ebUserEntity = ebUserService.getUserByUserId(member.getUserId());
                        if (ebUserEntity == null) {
                            log.info("分组成员id：{}，还未同步过陀螺匠，所以需要同步用户信息", member.getMemberId());
                            ebUserService.userCreate(member.getUserId(), employeeResponseList.get(0).getCredentialNumber(),
                                    employeeResponseList.get(0).getCardPhoto(), employeeResponseList.get(0).getHeadPhoto(),
                                    employeeResponseList.get(0).getEmployeeName(), employeeResponseList.get(0).getTelephone());
                        }
                        Long oaAndAttendanceRoleId = ebEnterpriseRoleService.createGetOaAndAttendanceRole(entid);
                        List<TenantDepartmentEmployeeRelationsEntity> departmentEmployeeRelationsEntityList = employeeResponseList.get(0).getGroupMemberRelationList();
                        ebAdminService.userJoin(member.getReferenceNumber(), entid, member.getUserId(), member.getMemberId(),
                                departmentEmployeeRelationsEntityList, null, member);
                        //同步员工其他信息
                        ebAdminService.setAdminOtherInfo(member.getMemberId(), oaAndAttendanceRoleId,
                                employeeResponseList.get(0).getCardPhoto(), null, member.getAfterIsDomainAdmin(), 0);
                    }
                } else {
                    log.info("组织id：{}，没有开通陀螺匠，所以不需要同步分组成员信息", member.getReferenceNumber());
                }
            }
        } catch (Exception e) {
            log.error("kafka监听tenant-employee表，异常：{}", e.getMessage(), e);
        }
        ack.acknowledge();
    }

}
