package com.bcxin.sync.common.utils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.bcxin.sync.common.CommonConstant;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;

@Component
public class TokenUtils {
    private static final String SECRET_KEY = "teemlink_obpm";

    public static String getBcxToken(HttpServletRequest request) {
        String token = request.getHeader(CommonConstant.REQUEST_HEADER_ACCESSTOKEN);
        if (StringUtils.isBlank(token)) {
            token = request.getParameter(CommonConstant.REQUEST_HEADER_ACCESSTOKEN);
        }
        return token;
    }

    public static String getEmployeeIdFromBcxToken(String bcxToken) {
        try {
            JWTVerifier xxx = JWT.require(Algorithm.HMAC256(SECRET_KEY)).withIssuer("auth0").acceptExpiresAt(1000 * 1000).build();
            DecodedJWT jwt = xxx.verify(bcxToken);
            String employeeId = jwt.getClaim("username").asString();
            return employeeId;
        } catch (Exception e) {
            return null;
        }
    }

    public static String generateBcxToken(String userId) {
        String token = null;
        try {
            Date expiresAt = new Date(System.currentTimeMillis() + 12 * 60 * 60 * 1000);
            token = JWT.create().withIssuer("auth0").withClaim("username", userId).withExpiresAt(expiresAt)
                    // 使用了HMAC256加密算法。
                    .sign(Algorithm.HMAC256(SECRET_KEY));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return token;

    }

    public static void main(String[] args) {
//        String user = "18292417675";//local user
//        String user = "org_aSuXCEfz";//test user
//        String user = "13888888888";//merchant
//        String user = "admin";//platform
//        String bcxToken = TokenUtils.generateBcxToken(user);
//        System.out.println(bcxToken);
//        String m = MD5Util.string2MD5("7BCX_ORDER_VERIFY1225");
//        System.out.println(m);
        String token = "eyJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJhdXRoMCIsImV4cCI6MTczMjI2MzgzMiwidXNlcm5hbWUiOiJWNjBHVnVTWiJ9.MjTBI7QINCl2iW7RmarH6-p1dJ-aIvGDVz0m5YFjcaA";
        String aa = TokenUtils.getEmployeeIdFromBcxToken(token);
        System.out.println(aa);
    }
}
