package com.bcxin.sync.service.tenant;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.common.utils.IdGeneratorSnowflake;
import com.bcxin.sync.dao.mapper.tenant.RbacPermitOptionRoleMapper;
import com.bcxin.sync.entity.tenant.RbacPermitOptionRoleEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * description：智能人事-权限操作项角色关联表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class RbacPermitOptionRoleService extends ServiceImpl<RbacPermitOptionRoleMapper, RbacPermitOptionRoleEntity> {

    @Autowired
    private IdGeneratorSnowflake snowflake;

    /**
     * description：通过角色id、操作项id，判断是否存在关联关系
     * author：linchunpeng
     * date：2025/2/19
     */
    public boolean isExistPermit(Long rbacRoleId, Long permitOptionId) {
        LambdaQueryChainWrapper<RbacPermitOptionRoleEntity> lqw = this.lambdaQuery();
        lqw.eq(RbacPermitOptionRoleEntity::getRbacRoleId, rbacRoleId);
        lqw.eq(RbacPermitOptionRoleEntity::getPermitOptionId, permitOptionId);
        return lqw.exists();
    }

    /**
     * description：通过角色id、操作项code，判断角色是否拥有对应的操作下
     * author：linchunpeng
     * date：2025/2/20
     */
    public boolean isRoleContainsOptionCode(Long rbacRoleId, List<String> optionCodeList) {
        LambdaQueryChainWrapper<RbacPermitOptionRoleEntity> lqw = this.lambdaQuery();
        lqw.eq(RbacPermitOptionRoleEntity::getRbacRoleId, rbacRoleId);
        lqw.in(RbacPermitOptionRoleEntity::getOptionCode, optionCodeList);
        return lqw.exists();
    }

    public RbacPermitOptionRoleEntity create(String organizationId, Long permitAppId, Long permitOptionId, Long roleId,
                                             String appCode, Integer optionType, String optionCode) {
        RbacPermitOptionRoleEntity optionRoleEntity = new RbacPermitOptionRoleEntity();
        optionRoleEntity.setId(snowflake.snowflakeId());
        optionRoleEntity.setOrganizationId(organizationId);
        optionRoleEntity.setPermitAppId(permitAppId);
        optionRoleEntity.setPermitOptionId(permitOptionId);
        optionRoleEntity.setRbacRoleId(roleId);
        optionRoleEntity.setAppCode(appCode);
        optionRoleEntity.setOptionType(optionType);
        optionRoleEntity.setOptionCode(optionCode);
        optionRoleEntity.setCreateTime(new Date());
        return optionRoleEntity;
    }

}