package com.bcxin.sync.service.tenant;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.common.utils.HttpUtil;
import com.bcxin.sync.common.utils.IdGeneratorSnowflake;
import com.bcxin.sync.dao.mapper.tenant.RbacCustomRoleMapper;
import com.bcxin.sync.dtos.response.UserRoleResponse;
import com.bcxin.sync.entity.tenant.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * description：智能人事-角色表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class RbacCustomRoleService extends ServiceImpl<RbacCustomRoleMapper, RbacCustomRoleEntity> {

    @Autowired
    private RbacPermitAppRoleService rbacPermitAppRoleService;
    @Autowired
    private RbacPermitOptionRoleService rbacPermitOptionRoleService;
    @Autowired
    private TenantEmployeesService tenantEmployeesService;
    @Autowired
    private RbacCustomRoleUserService rbacCustomRoleUserService;
    @Autowired
    private RbacPermitAppService rbacPermitAppService;
    @Autowired
    private RbacPermitOptionService rbacPermitOptionService;
    @Autowired
    private RbacPermitAppUserService rbacPermitAppUserService;
    @Autowired
    private RbacPermitOptionUserService rbacPermitOptionUserService;
    @Autowired
    private IdGeneratorSnowflake snowflake;
    @Value("${spring.profiles.active}")
    private String activeFile;

    private final static List<Map<String, String>> INIT_APP_List = new ArrayList<>();
    private final static List<Map<String, String>> INIT_OPTION_List = new ArrayList<>();
    static {
        Map<String, String> appMap1 = new HashMap<>();
        appMap1.put("permit_app_id", "47");
        appMap1.put("app_code", "__zidingyiyingyongPTJCGN");
        appMap1.put("permit_type", "1");
        INIT_APP_List.add(appMap1);
        Map<String, String> appMap2 = new HashMap<>();
        appMap2.put("permit_app_id", "67");
        appMap2.put("app_code", "__WkmM1dSxGEmoP8M9AxT");
        appMap2.put("permit_type", "1");
        INIT_APP_List.add(appMap2);
        Map<String, String> appMap3 = new HashMap<>();
        appMap3.put("permit_app_id", "53");
        appMap3.put("app_code", "__yXF3gCR1rLDkGP9l3Vm");
        appMap3.put("permit_type", "2");
        INIT_APP_List.add(appMap3);
        Map<String, String> appMap4 = new HashMap<>();
        appMap4.put("permit_app_id", "66");
        appMap4.put("app_code", "__nxvdMJ82R9ZsXae3UGL");
        appMap4.put("permit_type", "3");
        INIT_APP_List.add(appMap4);


        Map<String, String> optionMap1 = new HashMap<>();
        optionMap1.put("permit_option_id", "367");
        optionMap1.put("permit_app_id", "47");
        optionMap1.put("app_code", "__zidingyiyingyongPTJCGN");
        optionMap1.put("option_type", "1");
        optionMap1.put("option_code", "__ZiDingYiCaiDanXiaoXiZhongXin");
        INIT_OPTION_List.add(optionMap1);
        Map<String, String> optionMap2 = new HashMap<>();
        optionMap2.put("permit_option_id", "368");
        optionMap2.put("permit_app_id", "47");
        optionMap2.put("app_code", "__zidingyiyingyongPTJCGN");
        optionMap2.put("option_type", "1");
        optionMap2.put("option_code", "__ZiDingYiCaiDanGongZuoTai");
        INIT_OPTION_List.add(optionMap2);
        Map<String, String> optionMap3 = new HashMap<>();
        optionMap3.put("permit_option_id", "369");
        optionMap3.put("permit_app_id", "47");
        optionMap3.put("app_code", "__zidingyiyingyongPTJCGN");
        optionMap3.put("option_type", "1");
        optionMap3.put("option_code", "__ZiDingYiCaiDanGongGao");
        INIT_OPTION_List.add(optionMap3);
        Map<String, String> optionMap4 = new HashMap<>();
        optionMap4.put("permit_option_id", "370");
        optionMap4.put("permit_app_id", "47");
        optionMap4.put("app_code", "__zidingyiyingyongPTJCGN");
        optionMap4.put("option_type", "1");
        optionMap4.put("option_code", "__ZiDingYiCaiDanMenHu");
        INIT_OPTION_List.add(optionMap4);
        Map<String, String> optionMap5 = new HashMap<>();
        optionMap5.put("permit_option_id", "378");
        optionMap5.put("permit_app_id", "47");
        optionMap5.put("app_code", "__zidingyiyingyongPTJCGN");
        optionMap5.put("option_type", "1");
        optionMap5.put("option_code", "__ZiDingYiCaiDanSuoYouYingYong");
        INIT_OPTION_List.add(optionMap5);

        Map<String, String> optionMap6 = new HashMap<>();
        optionMap6.put("permit_option_id", "498");
        optionMap6.put("permit_app_id", "67");
        optionMap6.put("app_code", "__WkmM1dSxGEmoP8M9AxT");
        optionMap6.put("option_type", "1");
        optionMap6.put("option_code", "__cCpvhOVvD90oa0Ruoi7");
        INIT_OPTION_List.add(optionMap6);
        Map<String, String> optionMap7 = new HashMap<>();
        optionMap7.put("permit_option_id", "500");
        optionMap7.put("permit_app_id", "67");
        optionMap7.put("app_code", "__WkmM1dSxGEmoP8M9AxT");
        optionMap7.put("option_type", "1");
        optionMap7.put("option_code", "__AZNTtGILfYNdp0L4BZP");
        INIT_OPTION_List.add(optionMap7);

        Map<String, String> optionMap8 = new HashMap<>();
        optionMap8.put("permit_option_id", "507");
        optionMap8.put("permit_app_id", "53");
        optionMap8.put("app_code", "__yXF3gCR1rLDkGP9l3Vm");
        optionMap8.put("option_type", "2");
        optionMap8.put("option_code", "__lbiK33c4JBVuFV5QtLQ");
        INIT_OPTION_List.add(optionMap8);

        Map<String, String> optionMap9 = new HashMap<>();
        optionMap9.put("permit_option_id", "494");
        optionMap9.put("permit_app_id", "66");
        optionMap9.put("app_code", "__nxvdMJ82R9ZsXae3UGL");
        optionMap9.put("option_type", "1");
        optionMap9.put("option_code", "__FDvbl35Y1L78ETWTuZV");
        INIT_OPTION_List.add(optionMap9);
        Map<String, String> optionMap10 = new HashMap<>();
        optionMap10.put("permit_option_id", "495");
        optionMap10.put("permit_app_id", "66");
        optionMap10.put("app_code", "__nxvdMJ82R9ZsXae3UGL");
        optionMap10.put("option_type", "1");
        optionMap10.put("option_code", "__8xDFo7XT7jsQcnDFoCU");
        INIT_OPTION_List.add(optionMap10);
        Map<String, String> optionMap11 = new HashMap<>();
        optionMap11.put("permit_option_id", "492");
        optionMap11.put("permit_app_id", "66");
        optionMap11.put("app_code", "__nxvdMJ82R9ZsXae3UGL");
        optionMap11.put("option_type", "2");
        optionMap11.put("option_code", "__DsGkxqg4kx4pA7kkfzn");
        INIT_OPTION_List.add(optionMap11);
    }

    /**
     * description：获取<普通员工>角色id，不存在则创建一个
     * author：linchunpeng
     * date：2025/2/28
     */
    public Long getPTYGRoleIdByOrganizationId(String organizationId) {
        LambdaQueryChainWrapper<RbacCustomRoleEntity> lqw = this.lambdaQuery();
        lqw.eq(RbacCustomRoleEntity::getOrganizationId, organizationId);
        lqw.eq(RbacCustomRoleEntity::getRoleName, "普通员工");
        lqw.eq(RbacCustomRoleEntity::getRoleType, 1);
        List<RbacCustomRoleEntity> list = lqw.list();
        Long roleId = snowflake.snowflakeId();
        if (CollectionUtil.isNotEmpty(list)) {
            //已存在
            roleId = list.get(0).getId();
        } else {
            //不存在
            RbacCustomRoleEntity entity = new RbacCustomRoleEntity();
            entity.setId(roleId);
            entity.setOrganizationId(organizationId);
            entity.setRoleName("普通员工");
            entity.setRoleType(1);
            entity.setRemark("系统角色");
            entity.setStatus(1);
            entity.setSeq(1);
            entity.setCreateTime(new Date());
            this.save(entity);
        }
        return roleId;
    }


    /**
     * description：初始化"普通员工"角色
     * author：linchunpeng
     * date：2025/2/26
     */
    @Transactional
    public void initRole(String organizationId) {
        log.info("新增<普通员工>角色");
        Long roleId = this.getPTYGRoleIdByOrganizationId(organizationId);
        log.info("新增<普通员工-应用>授权");
        List<RbacPermitAppRoleEntity> appRoleEntityList = new ArrayList<>();
        for (Map<String, String> map : INIT_APP_List) {
            Long permitAppId = Long.parseLong(map.get("permit_app_id"));
            String appCode = map.get("app_code");
            Integer permitType = Integer.parseInt(map.get("permit_type"));
            if (!rbacPermitAppRoleService.isExistApp(permitAppId, roleId)) {
                appRoleEntityList.add(rbacPermitAppRoleService.create(organizationId, permitAppId, roleId, appCode, permitType));
            }
        }
        if (CollectionUtil.isNotEmpty(appRoleEntityList)) {
            rbacPermitAppRoleService.saveBatch(appRoleEntityList);
        }
        log.info("新增<普通员工-操作项>授权");
        List<RbacPermitOptionRoleEntity> optionRoleEntityList = new ArrayList<>();
        for (Map<String, String> map : INIT_OPTION_List) {
            Long permitAppId = Long.parseLong(map.get("permit_app_id"));
            Long permitOptionId = Long.parseLong(map.get("permit_option_id"));
            String appCode = map.get("app_code");
            Integer optionType = Integer.parseInt(map.get("option_type"));
            String optionCode = map.get("option_code");
            if (!rbacPermitOptionRoleService.isExistPermit(roleId, permitOptionId)) {
                optionRoleEntityList.add(rbacPermitOptionRoleService.create(organizationId, permitAppId, permitOptionId, roleId, appCode, optionType, optionCode));
            }
        }
        if (CollectionUtil.isNotEmpty(optionRoleEntityList)) {
            rbacPermitOptionRoleService.saveBatch(optionRoleEntityList);
        }
        log.info("全部员工加入<普通员工>角色");
        List<TenantEmployeesEntity> employeesEntityList = tenantEmployeesService.getByOrgId(organizationId);
        if (CollectionUtil.isNotEmpty(employeesEntityList)) {
            List<RbacCustomRoleUserEntity> roleUserEntityList = new ArrayList<>();
            for (TenantEmployeesEntity employeesEntity : employeesEntityList) {
                if (!rbacCustomRoleUserService.isExistEmployee(roleId, employeesEntity.getId())) {
                    roleUserEntityList.add(rbacCustomRoleUserService.create(organizationId, roleId, employeesEntity.getId()));
                }
            }
            if (CollectionUtil.isNotEmpty(roleUserEntityList)) {
                rbacCustomRoleUserService.saveBatch(roleUserEntityList);
            }
        }
    }


    /**
     * description：初始化用户权限(升级高级版之前的权限同步到高级版)
     * author：linchunpeng
     * date：2025/2/26
     */
    @Transactional
    public void initUserPermit(String organizationId) {
        log.info("初始化用户权限(升级高级版之前的权限同步到高级版)");
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("organizationId", organizationId);
        List<UserRoleResponse> userRoleResponseList = this.baseMapper.selectUserRoleList(paramMap);
        if (CollectionUtil.isNotEmpty(userRoleResponseList)) {
            log.info("旧版用户授权不为空");
            List<RbacPermitAppEntity> permitAppEntityList = rbacPermitAppService.list();
            List<RbacPermitOptionEntity> permitOptionEntityList = rbacPermitOptionService.list();
            Map<String, RbacPermitAppEntity> permitAppEntityMap = permitAppEntityList.stream().collect(Collectors.toMap(RbacPermitAppEntity::getAppCode, Function.identity()));
            Map<String, List<RbacPermitOptionEntity>> permitOptionEntityListMap = permitOptionEntityList.stream().collect(Collectors.groupingBy(RbacPermitOptionEntity::getAppCode));

            Map<String, String> roleAppMap = new HashMap<>();
            Set<String> employeeIdApCodeSet = new HashSet<>();
            for (UserRoleResponse userRoleResponse : userRoleResponseList) {
                String appCode = roleAppMap.get(userRoleResponse.getRoleid());
                if (StringUtils.isBlank(appCode)) {
                    log.info("map不存在，从接口获取");
                    String result = HttpUtil.get("https://v5qy.baibaodun.cn/obpm/v3/extends/components/" + userRoleResponse.getRoleid(),
                            new HashMap<>(), "test".equals(activeFile));
                    if (StringUtils.isNotBlank(result)) {
                        JSONObject jsonObject = JSONObject.parseObject(result);
                        if (jsonObject.containsKey("appId")) {
                            appCode = jsonObject.getString("appId");
                            log.info("appCode={}", appCode);
                        } else {
                            log.info("没有appid，无需初始化");
                        }
                    }
                    if (StringUtils.isNotBlank(appCode)) {
                        roleAppMap.put(userRoleResponse.getRoleid(), appCode);
                    }
                }
                if (StringUtils.isNotBlank(appCode) && employeeIdApCodeSet.add(userRoleResponse.getUserid().concat(appCode))) {
                    log.info("初始化用户权限");
                    RbacPermitAppEntity permitApp = permitAppEntityMap.get(appCode);
                    List<RbacPermitOptionEntity> permitOptionList = permitOptionEntityListMap.get(appCode);
                    if (permitApp != null && CollectionUtil.isNotEmpty(permitOptionList)) {
                        rbacPermitAppUserService.deleteByTenantEmployeeIdAndAppCode(userRoleResponse.getUserid(), appCode);
                        rbacPermitOptionUserService.deleteByTenantEmployeeIdAndAppCode(userRoleResponse.getUserid(), appCode);
                        log.info("初始化用户app权限");
                        RbacPermitAppUserEntity rbacPermitAppUserEntity = new RbacPermitAppUserEntity();
                        rbacPermitAppUserEntity.setId(snowflake.snowflakeId());
                        rbacPermitAppUserEntity.setOrganizationId(organizationId);
                        rbacPermitAppUserEntity.setPermitAppId(permitApp.getId());
                        rbacPermitAppUserEntity.setTenantEmployeeId(userRoleResponse.getUserid());
                        rbacPermitAppUserEntity.setAppCode(appCode);
                        rbacPermitAppUserEntity.setPermitType(permitApp.getAppType());
                        rbacPermitAppUserEntity.setCreateTime(new Date());
                        rbacPermitAppUserService.save(rbacPermitAppUserEntity);

                        log.info("初始化用户option权限");
                        List<RbacPermitOptionUserEntity> rbacPermitOptionUserEntityList = new ArrayList<>();
                        for (RbacPermitOptionEntity permitOption : permitOptionList) {
                            RbacPermitOptionUserEntity rbacPermitOptionUserEntity = new RbacPermitOptionUserEntity();
                            rbacPermitOptionUserEntity.setId(snowflake.snowflakeId());
                            rbacPermitOptionUserEntity.setOrganizationId(organizationId);
                            rbacPermitOptionUserEntity.setPermitAppId(permitApp.getId());
                            rbacPermitOptionUserEntity.setPermitOptionId(permitOption.getId());
                            rbacPermitOptionUserEntity.setTenantEmployeeId(userRoleResponse.getUserid());
                            rbacPermitOptionUserEntity.setAppCode(appCode);
                            rbacPermitOptionUserEntity.setOptionType(permitOption.getOptionType());
                            rbacPermitOptionUserEntity.setOptionCode(permitOption.getOptionCode());
                            rbacPermitOptionUserEntity.setCreateTime(new Date());
                            rbacPermitOptionUserEntityList.add(rbacPermitOptionUserEntity);
                        }
                        rbacPermitOptionUserService.saveBatch(rbacPermitOptionUserEntityList);
                    }
                }
            }
        }
    }

}