package com.bcxin.sync.service;

import com.bcxin.sync.dao.mapper.tenant.TenantEmployeesMapper;
import com.bcxin.sync.entity.tenant.TenantEmployeesEntity;
import com.bcxin.sync.entity.tenant.TenantUsersEntity;
import com.bcxin.sync.service.tenant.TenantEmployeesService;
import com.bcxin.sync.service.tenant.TenantUsersService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class UserDetailsServiceImpl implements UserDetailsService {

    @Autowired
    private TenantUsersService tenantUsersService;
    @Autowired
    private TenantEmployeesService tenantEmployeesService;

    /**
     * SpringSecurity会调用UserDetailsService的loadUserByUsername方法验证用户名是否合法
     * @param username
     * @return
     */
    @Override
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
//        1.通过职员id查询职员信息
        TenantEmployeesEntity employee = tenantEmployeesService.getById(username);
        if (employee == null) {
            throw new RuntimeException("用户名不正确");
        }
        TenantUsersEntity user = tenantUsersService.getById(employee.getTenantUserId());
        /**
         * 此时的User中需要包含用户名信息,用户密码信息,用户权限信息
         * 用户名信息: username
         * 用户密码信息: 真实密码信息加密处理后的加密信息
         * 用户权限信息: 是根据用户名查出的权限字符串信息,这里暂时只处理认证,不处理授权,所以无须查询用户权限信息.
         */
//        2.将User信息封装到UserDetails对象中
        UserDetails userDetails = new UserDetailsImpl(user, employee);

        return userDetails;
    }
}
