package com.bcxin.sync.service;

import com.bcxin.sync.entity.tenant.TenantEmployeesEntity;
import com.bcxin.sync.entity.tenant.TenantUsersEntity;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UserDetailsImpl implements UserDetails {

    private TenantUsersEntity tenantUsersEntity;
    private TenantEmployeesEntity tenantEmployeesEntity;

    public UserDetailsImpl(TenantUsersEntity tenantUsersEntity, TenantEmployeesEntity tenantEmployeesEntity) {
        this.tenantUsersEntity = tenantUsersEntity;
        this.tenantEmployeesEntity = tenantEmployeesEntity;
    }

    /**
     * 获取权限信息
     * @return
     */
    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        List<SimpleGrantedAuthority> authorities = new ArrayList<>();
        authorities.add(new SimpleGrantedAuthority("USER"));
        return authorities;
    }

    /**
     * 获取密码信息
     * @return
     */
    @Override
    public String getPassword() {
        BCryptPasswordEncoder encoder = new BCryptPasswordEncoder();
        return encoder.encode(this.tenantEmployeesEntity.getId());
    }

    /**
     * 获取用户名信息
     * @return
     */
    @Override
    public String getUsername() {
        return this.tenantEmployeesEntity.getId();
    }

    @Override
    public boolean isAccountNonExpired() {
        return true;
    }

    @Override
    public boolean isAccountNonLocked() {
        return true;
    }

    @Override
    public boolean isCredentialsNonExpired() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}
