package com.bcxin.sync.entity.tuoluojiang;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;

/**
 * description：陀螺匠-审批规则表
 * author：linchunpeng
 * date：2024/12/31
 */
@Data
@TableName("eb_approve_rule")
public class EbApproveRuleEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    //主键id
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    //用户表id
    private Long userId;

    //用户表id
    private Long cardId;

    //企业id
    private Long entid;

    //审批id
    private Long approveId;

    //可见范围
    @TableField("`range`")
    private String range;

    //异常处理：0、自动同意；指定处理人ID
    private Long abnormal;

    //自动审批：0、首个节点处理，其他自动同意；1、连续审批自动同意；2、每个节点都需审批；
    private String auto;

    //修改权限：0、员工不可修改固定人员；1、不可删除固定抄送人；
    private String edit;

    //异常处理：1、审批通过后允许撤销；
    private Integer recall;

    //是否可转审
    private Integer isTransfer;

    //是否可加签
    private Integer isSign;

    //被拒绝后：0、返回初始，所有人重新审批；1、跳过已通过层级
    private Integer refuse;

}