package com.bcxin.sync.controller;


import com.alibaba.fastjson.JSONObject;
import com.bcxin.sync.dtos.response.BcxEmployeeResponse;
import com.bcxin.sync.entity.tenant.TenantDepartmentEmployeeRelationsEntity;
import com.bcxin.sync.entity.tenant.TenantEmployeesEntity;
import com.bcxin.sync.service.tenant.TenantDepartmentEmployeeRelationsService;
import com.bcxin.sync.service.tenant.TenantEmployeesService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@RestController
public class UserController {

    @Autowired
    private TenantEmployeesService tenantEmployeesService;
    @Autowired
    private TenantDepartmentEmployeeRelationsService tenantDepartmentEmployeeRelationsService;


    @RequestMapping("/user/info")
    public Map<String, Object> userInfo() {
        log.info("统一登录获取用户信息");
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        String username = authentication.getName();
        log.info("统一登录获取用户信息，username：{}", username);
        TenantEmployeesEntity employee = tenantEmployeesService.getById(username);
        List<BcxEmployeeResponse> employeeResponseList = tenantEmployeesService.getEmployeeResponseListByEmployeeIdList(Collections.singletonList(employee.getId()), null);
        List<TenantDepartmentEmployeeRelationsEntity> departmentEmployeeRelationsEntityList = tenantDepartmentEmployeeRelationsService.getListByEmployeeIdList(Collections.singletonList(employee.getId()));
        Map<String, Object> resultMap = new HashMap<>();
        resultMap.put("id", employeeResponseList.get(0).getUserId());
        resultMap.put("username", employeeResponseList.get(0).getEmployeeName());
        resultMap.put("credentialNumber", employeeResponseList.get(0).getCredentialNumber());
        resultMap.put("deptId", departmentEmployeeRelationsEntityList.get(0).getDepartmentId());
        log.info("统一登录获取用户信息，resultMap：{}", JSONObject.toJSONString(resultMap));
        return resultMap;
    }

}
