package com.bcxin.sync.controller;


import com.bcxin.sync.dtos.request.DepartmentSyncRequest;
import com.bcxin.sync.dtos.request.EmployeeSyncRequest;
import com.bcxin.sync.dtos.request.OrganizationSyncRequest;
import com.bcxin.sync.dtos.request.UserSyncRequest;
import com.bcxin.sync.dtos.response.result.RespResult;
import com.bcxin.sync.service.DataSyncToJvsService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * description：同步JVS接口
 * author：linchunpeng
 * date：2025/2/11
 */
@Slf4j
@RestController
public class SyncToJvsController {


    @Autowired
    private DataSyncToJvsService dataSyncToJvsService;

    /**
     * 开通陀螺匠
     */
    @PostMapping("/api/jvs/sync")
    public RespResult<String> sync(@RequestBody @Validated OrganizationSyncRequest request) {
        return RespResult.successful(dataSyncToJvsService.sync(request.getOrganizationId()));
    }

    /**
     * 同步用户
     */
    @PostMapping("/api/jvs/sync/user")
    public RespResult<String> syncUser(@RequestBody @Validated UserSyncRequest request) {
        dataSyncToJvsService.syncUser(request);
        return RespResult.successful("同步成功");
    }

    /**
     * 同步部门
     */
    @PostMapping("/api/jvs/sync/department")
    public RespResult<String> syncDepartment(@RequestBody @Validated DepartmentSyncRequest request) {
        dataSyncToJvsService.syncDepartment(request);
        return RespResult.successful("同步成功");
    }

    /**
     * 同步员工
     */
    @PostMapping("/api/jvs/sync/employee")
    public RespResult<String> syncEmployee(@RequestBody @Validated EmployeeSyncRequest request) {
        dataSyncToJvsService.syncEmployee(request);
        return RespResult.successful("同步成功");
    }

}
