package com.bcxin.sync.controller;


import com.alibaba.fastjson.JSONObject;
import com.bcxin.sync.common.exception.GetResponseException;
import com.bcxin.sync.configs.SyncConfig;
import com.bcxin.sync.dtos.request.NotPasswordLoginRequest;
import com.bcxin.sync.dtos.request.TokenLoginRequest;
import com.bcxin.sync.service.DataSyncToTljService;
import com.bcxin.sync.service.LoginService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

import javax.servlet.http.HttpServletRequest;

@Slf4j
@Controller
public class LoginController {

    @Autowired
    private DataSyncToTljService dataSyncToTljService;
    @Autowired
    private LoginService loginService;
    @Autowired
    private SyncConfig syncConfig;

    /**
     * 陀螺匠-免密登录链接
     */
    @GetMapping("/api/tlj/not/password/login/url")
    public String tljNotPasswordLoginUrl(NotPasswordLoginRequest request) {
        log.info("陀螺匠-登录请求：{}", JSONObject.toJSONString(request));
        String reseult = dataSyncToTljService.getLoginEncrypt(request, false);
        log.info("结果：{}", reseult);
        return "redirect:" + reseult;
    }

    /**
     * 陀螺匠-免密登录链接-h5
     */
    @GetMapping("/api/tlj/h5/not/password/login/url")
    public String tljH5NotPasswordLoginUrl(NotPasswordLoginRequest request) {
        log.info("陀螺匠-h5登录请求：{}", JSONObject.toJSONString(request));
        String reseult = dataSyncToTljService.getLoginEncrypt(request, true);
        log.info("结果：{}", reseult);
        return "redirect:" + reseult;
    }

    /**
     * 统一登录
     */
    @GetMapping("/api/oauth2/{target}/login")
    public String login(@PathVariable("target") String target, TokenLoginRequest request, HttpServletRequest httpRequest) {
        log.info("统一登录请求，target：{}, 参数：{}", target, JSONObject.toJSONString(request));
        boolean reseult = loginService.loginByEmployeeId(request.getEmpId(), httpRequest);
        log.info("结果：{}", reseult);
        if ("jvs".equals(target)) {
            return "redirect:" + syncConfig.getApiHost().getJvsOauthCallback();
        }
        throw new GetResponseException(403, "禁止访问.");
    }
}
