package com.bcxin.sync.consumer;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.sync.common.CommonConstant;
import com.bcxin.sync.common.emus.OpenType;
import com.bcxin.sync.common.utils.KafkaMessageUtil;
import com.bcxin.sync.dtos.kafka.message.RbacPermitOptionRoleSyncMessage;
import com.bcxin.sync.entity.tenant.RbacCustomRoleUserEntity;
import com.bcxin.sync.entity.tuoluojiang.EbAdminEntity;
import com.bcxin.sync.service.datasync.OrganizationOpenService;
import com.bcxin.sync.service.tenant.RbacCustomRoleUserService;
import com.bcxin.sync.service.tenant.RbacPermitOptionRoleService;
import com.bcxin.sync.service.tenant.TenantOrganizationsService;
import com.bcxin.sync.service.tuoluojiang.EbAdminService;
import com.bcxin.sync.service.tuoluojiang.EbAttendanceWhitelistService;
import com.bcxin.sync.service.tuoluojiang.EbEnterpriseService;
import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 权限操作项角色关联表kafka监听器
 */
@Component
@Slf4j
public class RbacPermitOptionRoleKafkaConsumer {

    @Autowired
    private EbAdminService ebAdminService;
    @Autowired
    private EbEnterpriseService ebEnterpriseService;
    @Autowired
    private EbAttendanceWhitelistService ebAttendanceWhitelistService;
    @Autowired
    private OrganizationOpenService organizationOpenService;
    @Autowired
    private RbacCustomRoleUserService rbacCustomRoleUserService;
    @Autowired
    private RbacPermitOptionRoleService rbacPermitOptionRoleService;
    @Autowired
    private TenantOrganizationsService tenantOrganizationsService;

    @KafkaListener(id = "bcx_data_sync_listener_rbac_permit_option_role_to_tlj",
            topics = CommonConstant.RBAC_PERMIT_OPTION_ROLE_KAFKA_TOPIC,
            groupId = "bcx_data_sync_rbac_permit_option_role_to_tlj")
    public void bcxDataSyncRbacPermitOptionRoleToTlj(ConsumerRecord<String, String> record, Acknowledgment ack) {
        RbacPermitOptionRoleSyncMessage rbacPermitOptionRole = KafkaMessageUtil.transferKafkaRbacPermitOptionRole2Message(record);
        log.info("kafka监听rbac_permit_option_role表，数据转化为：{}", JSONObject.toJSONString(rbacPermitOptionRole));
        try {
            if (CommonConstant.NEED_SYNC_PERMIT_CODES.contains(rbacPermitOptionRole.getOptionCode())) {
                log.info("权限{},是需要同步的", rbacPermitOptionRole.getOptionCode());
                boolean openAndEffective = organizationOpenService.isOpenAndEffective(rbacPermitOptionRole.getOrganizationId(), OpenType.TLJ.getCode());
                Integer leve = tenantOrganizationsService.getLevelByOrgId(rbacPermitOptionRole.getOrganizationId());
                if (openAndEffective && leve == 2) {
                    Long entid = ebEnterpriseService.getIdByOrgId(rbacPermitOptionRole.getOrganizationId());
                    if (entid != null) {
                        log.info("组织id：{}，有开通陀螺匠，所以需要同步权限信息", rbacPermitOptionRole.getOrganizationId());
                        //是否存在关联关系
                        boolean existPermit = rbacPermitOptionRoleService.isExistPermit(rbacPermitOptionRole.getRbacRoleId(), rbacPermitOptionRole.getPermitOptionId());
                        //取出角色关联的用户列表
                        List<RbacCustomRoleUserEntity> roleUserEntityList = rbacCustomRoleUserService.getListByRbacRoleId(rbacPermitOptionRole.getRbacRoleId());
                        if (CollectionUtil.isNotEmpty(roleUserEntityList)) {
                            List<EbAdminEntity> adminEntityList = ebAdminService.getListByEmployeeIdList(roleUserEntityList.stream().map(RbacCustomRoleUserEntity::getTenantEmployeeId).collect(Collectors.toList()), entid);
                            if (CollectionUtil.isNotEmpty(adminEntityList)) {
                                for (EbAdminEntity admin : adminEntityList) {
                                    if (existPermit) {
                                        //存在关联关系，即表示新增权限
                                        if (CommonConstant.ATTENDANCE_MANAGER_CODE.equals(rbacPermitOptionRole.getOptionCode())) {
                                            log.info("组织id：{}，职员id：{}，新增考勤管理员权限信息", rbacPermitOptionRole.getOrganizationId(), admin.getUniqued());
                                            ebAttendanceWhitelistService.attendanceWhitelistCreate(entid, admin.getId(), 1);
                                        }
                                    } else {
                                        //不存在关联关系，即表示删除权限
                                        if (CommonConstant.ATTENDANCE_MANAGER_CODE.equals(rbacPermitOptionRole.getOptionCode())) {
                                            log.info("组织id：{}，职员id：{}，删除考勤管理员权限信息", rbacPermitOptionRole.getOrganizationId(), admin.getUniqued());
                                            ebAttendanceWhitelistService.attendanceWhitelistDelete(admin.getId(), 1);
                                        }
                                    }
                                }
                            }
                        }
                    }
                } else {
                    log.info("组织id：{}，没开通陀螺匠，所以不需要同步权限信息", rbacPermitOptionRole.getOrganizationId());
                }
            } else {
                log.info("权限{},是不需要同步的", rbacPermitOptionRole.getOptionCode());
            }
        } catch (Exception e) {
            log.error("kafka监听rbac_permit_option_role表，异常：{}", e.getMessage(), e);
        }
        ack.acknowledge();
    }
}
