package com.bcxin.sync.consumer;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.sync.common.CommonConstant;
import com.bcxin.sync.common.emus.DataOperationType;
import com.bcxin.sync.common.emus.OpenType;
import com.bcxin.sync.common.utils.KafkaMessageUtil;
import com.bcxin.sync.dtos.kafka.message.RbacCustomRoleUserSyncMessage;
import com.bcxin.sync.service.datasync.OrganizationOpenService;
import com.bcxin.sync.service.tenant.RbacPermitOptionRoleService;
import com.bcxin.sync.service.tenant.TenantOrganizationsService;
import com.bcxin.sync.service.tuoluojiang.EbAdminService;
import com.bcxin.sync.service.tuoluojiang.EbAttendanceWhitelistService;
import com.bcxin.sync.service.tuoluojiang.EbEnterpriseService;
import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Component;

/**
 * 角色用户关联表kafka监听器
 */
@Component
@Slf4j
public class RbacCustomRoleUserKafkaConsumer {

    @Autowired
    private EbAdminService ebAdminService;
    @Autowired
    private EbEnterpriseService ebEnterpriseService;
    @Autowired
    private EbAttendanceWhitelistService ebAttendanceWhitelistService;
    @Autowired
    private OrganizationOpenService organizationOpenService;
    @Autowired
    private RbacPermitOptionRoleService rbacPermitOptionRoleService;
    @Autowired
    private TenantOrganizationsService tenantOrganizationsService;


    @KafkaListener(id = "bcx_data_sync_listener_rbac_custom_role_user_to_tlj",
            topics = CommonConstant.RBAC_CUSTOM_ROLE_USER_KAFKA_TOPIC,
            groupId = "bcx_data_sync_rbac_custom_role_user_to_tlj")
    public void bcxDataSyncRbacCustomRoleUserToTlj(ConsumerRecord<String, String> record, Acknowledgment ack) {
        RbacCustomRoleUserSyncMessage rbacCustomRoleUser = KafkaMessageUtil.transferKafkaRbacCustomRoleUser2Message(record);
        log.info("kafka监听rbac_custom_role_user表，数据转化为：{}", JSONObject.toJSONString(rbacCustomRoleUser));
        try {
            boolean openAndEffective = organizationOpenService.isOpenAndEffective(rbacCustomRoleUser.getOrganizationId(), OpenType.TLJ.getCode());
            Integer leve = tenantOrganizationsService.getLevelByOrgId(rbacCustomRoleUser.getOrganizationId());
            if (openAndEffective && leve == 2) {
                Long entid = ebEnterpriseService.getIdByOrgId(rbacCustomRoleUser.getOrganizationId());
                if (entid != null) {
                    log.info("组织id：{}，有开通陀螺匠，所以需要同步权限信息", rbacCustomRoleUser.getOrganizationId());
                    boolean isRoleContainsOptionCode = rbacPermitOptionRoleService.isRoleContainsOptionCode(rbacCustomRoleUser.getRbacRoleId(), CommonConstant.NEED_SYNC_PERMIT_CODES);
                    if (isRoleContainsOptionCode) {
                        log.info("角色：{},是需要同步的", rbacCustomRoleUser.getRbacRoleId());
                        Long adminId = ebAdminService.getIdByEmployeeId(rbacCustomRoleUser.getTenantEmployeeId(), entid);
                        if (adminId != null && rbacCustomRoleUser.getType().getCode() == DataOperationType.CREATE.getCode()) {
                            //新增权限
//                        if (CommonConstant.ATTENDANCE_MANAGER_CODE.equals(rbacPermitOptionRole.getOptionCode())) {
                            log.info("组织id：{}，职员id：{}，新增考勤管理员权限信息", rbacCustomRoleUser.getOrganizationId(), rbacCustomRoleUser.getTenantEmployeeId());
                            ebAttendanceWhitelistService.attendanceWhitelistCreate(entid, adminId, 1);
//                        }
                        } else if (adminId != null && rbacCustomRoleUser.getType().getCode() == DataOperationType.DELETE.getCode()) {
                            //删除权限
//                        if (CommonConstant.ATTENDANCE_MANAGER_CODE.equals(rbacPermitOptionRole.getOptionCode())) {
                            log.info("组织id：{}，职员id：{}，删除考勤管理员权限信息", rbacCustomRoleUser.getOrganizationId(), rbacCustomRoleUser.getTenantEmployeeId());
                            ebAttendanceWhitelistService.attendanceWhitelistDelete(adminId, 1);
//                        }
                        }
                    } else {
                        log.info("角色：{},是不需要同步的", rbacCustomRoleUser.getRbacRoleId());
                    }
                }
            } else {
                log.info("组织id：{}，没开通陀螺匠或没开通高级版，所以不需要同步权限信息", rbacCustomRoleUser.getOrganizationId());
            }
        } catch (Exception e) {
            log.error("kafka监听rbac_custom_role_user表，异常：{}", e.getMessage(), e);
        }
        ack.acknowledge();
    }
}
