package cn.myapps.upgrade.dao;

import cn.myapps.common.FileSystemDesignTimeSerializable;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.datasource.DataSource;
import cn.myapps.common.model.excelimport.IMPMappingConfigVO;
import cn.myapps.common.model.macrorepository.RepositoryVO;
import cn.myapps.common.model.module.Module;
import cn.myapps.common.model.multilanguage.MultiLanguage;
import cn.myapps.common.model.report.Report;
import cn.myapps.common.model.resource.ResourceVO;
import cn.myapps.common.model.statelabel.StateLabel;
import cn.myapps.common.model.stylerepository.StyleRepositoryVO;
import cn.myapps.common.model.summary.SummaryCfgVO;
import cn.myapps.common.model.task.Task;
import cn.myapps.common.model.validaterepository.ValidateRepositoryVO;
import cn.myapps.common.model.view.AbstractView;
import cn.myapps.common.model.widget.PageWidget;
import cn.myapps.common.model.workflow.BillDefiVO;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceFactory;
import cn.myapps.run.Start;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.upgrade.util.DaoManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.Collection;

@RunWith(SpringRunner.class)
@SpringBootTest(classes= Start.class)
public class UpgradeDaoTest {
	
	private UpgradeDao upgradeDao;

	/**
	 * 获取DAO
	 */
	@Before
	public void getUpGradeDao(){
		try {
			upgradeDao = DaoManager.getUpGradeDAO();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	/**
	 * 数据库测试
	 * @throws Exception
	 */
	@Test
	public void testDataSource() throws Exception {
		UpgradeDao upgradeDAO = DaoManager.getUpGradeDAO();
		Assert.assertNotNull(upgradeDAO);
		
	}
	
	@Test
	public void queryApplications() throws Exception {
		Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryApplications();
		
		for(FileSystemDesignTimeSerializable tmp : list){
			
			if(tmp instanceof Application){
				Application app = (Application) tmp;
				//System.out.println(app.toString());
			}
		}
		
		ApplicationDesignTimeService applicationProcess = (ApplicationDesignTimeService) DesignTimeServiceFactory.resolve(ApplicationDesignTimeService.class);;
		
		for(FileSystemDesignTimeSerializable tmp : list){
			if(tmp instanceof Application){
				Application obj = (Application) tmp;
				applicationProcess.save(obj);
			}
		}

	}

	@Test
	public void queryDataSources() throws Exception {
		Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryDataSources();
		
		for(FileSystemDesignTimeSerializable tmp : list){
			if(tmp instanceof DataSource){
				DataSource obj = (DataSource) tmp;
				//System.out.println(obj.toString());
			}
		}
	}

	@Test
	public void queryModules() throws Exception {
        Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryModules();
		
		for(FileSystemDesignTimeSerializable tmp : list){
			if(tmp instanceof Module){
				Module obj = (Module) tmp;
				//System.out.println(obj.toString());
			}
		}
	}

	@Test
	public void queryForms() throws Exception {
		  Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryForms();
			
			for(FileSystemDesignTimeSerializable tmp : list){
				if(tmp instanceof Form){
					Form obj = (Form) tmp;
					//System.out.println(obj.toString());
				}
			}
	}

	@Test
	public void queryViews() throws Exception {
		  Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryViews();
			
			for(FileSystemDesignTimeSerializable tmp : list){
				if(tmp instanceof AbstractView){
					AbstractView obj = (AbstractView) tmp;
					//System.out.println(obj.toString());
				}
			}
	}

	@Test
	public void querySummarys() throws Exception {
		 Collection<FileSystemDesignTimeSerializable> list = upgradeDao.querySummarys();
		 
			for(FileSystemDesignTimeSerializable tmp : list){
				if(tmp instanceof SummaryCfgVO){
					SummaryCfgVO obj = (SummaryCfgVO) tmp;
					//System.out.println(obj.toString());
				}
			}
	}

	@Test
	public void queryFlows() throws Exception {
		Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryFlows();
		 
		for(FileSystemDesignTimeSerializable tmp : list){
			if(tmp instanceof BillDefiVO){
				BillDefiVO obj = (BillDefiVO) tmp;
				//System.out.println(obj.toString());
			}
		}
	}

	@Test
	public void queryResouces() throws Exception {
		 Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryResouces();
		 
			for(FileSystemDesignTimeSerializable tmp : list){
				if(tmp instanceof ResourceVO){
					ResourceVO obj = (ResourceVO) tmp;
					//System.out.println(obj.toString());
				}
			}
	}

	@Test
	public void queryCrossReports() throws Exception {
		// TODO Auto-generated method stub
		
	}

	@Test
	public void queryExlcfgs() throws Exception {
		 Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryExlcfgs();
		 
			for(FileSystemDesignTimeSerializable tmp : list){
				if(tmp instanceof IMPMappingConfigVO){
					IMPMappingConfigVO obj = (IMPMappingConfigVO) tmp;
					//System.out.println(obj.toString());
				}
			}
	}

	@Test
	public void queryTasks() throws Exception {
		 Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryTasks();
		 
			for(FileSystemDesignTimeSerializable tmp : list){
				if(tmp instanceof Task){
					Task obj = (Task) tmp;
					//System.out.println(obj.toString());
				}
			}
	}

	@Test
	public void queryWidgets() throws Exception {
		 Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryWidgets();
		 
			for(FileSystemDesignTimeSerializable tmp : list){
				if(tmp instanceof PageWidget){
					PageWidget obj = (PageWidget) tmp;
					//System.out.println(obj.toString());
				}
			}
	}

	@Test
	public void queryStateLabels() throws Exception {
		 Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryStateLabels();
		 
			for(FileSystemDesignTimeSerializable tmp : list){
				if(tmp instanceof StateLabel){
					StateLabel obj = (StateLabel) tmp;
					//System.out.println(obj.toString());
				}
			}
	}

	@Test
	public void queryPrints() throws Exception {
		 Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryPrints();
		 
			for(FileSystemDesignTimeSerializable tmp : list){
				if(tmp instanceof Report){
					Report obj = (Report) tmp;
					//System.out.println(obj.toString());
				}
			}
	}

	@Test
	public void queryMacroRepositorys() throws Exception {
		 Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryMacroRepositorys();
		 
			for(FileSystemDesignTimeSerializable tmp : list){
				if(tmp instanceof RepositoryVO){
					RepositoryVO obj = (RepositoryVO) tmp;
					//System.out.println(obj.toString());
				}
			}
		
	}

	@Test
	public void queryValidRepositorys() throws Exception {
		 Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryValidRepositorys();
		 
			for(FileSystemDesignTimeSerializable tmp : list){
				if(tmp instanceof ValidateRepositoryVO){
					ValidateRepositoryVO obj = (ValidateRepositoryVO) tmp;
					//System.out.println(obj.toString());
				}
			}
	}

	@Test
	public void queryStyleRepositorys() throws Exception {
		 Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryStyleRepositorys();
		 
			for(FileSystemDesignTimeSerializable tmp : list){
				if(tmp instanceof StyleRepositoryVO){
					StyleRepositoryVO obj = (StyleRepositoryVO) tmp;
					//System.out.println(obj.toString());
				}
			}
	}

	@Test
	public void queryMulitlangs() throws Exception {
		 Collection<FileSystemDesignTimeSerializable> list = upgradeDao.queryMulitlangs();
		 
			for(FileSystemDesignTimeSerializable tmp : list){
				if(tmp instanceof MultiLanguage){
					MultiLanguage obj = (MultiLanguage) tmp;
					//System.out.println(obj.toString());
				}
			}
	}

}
